/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch;

import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.misc.DumpManager;
import dev.mattidragon.jsonpatcher.misc.ResourceAccess;
import dev.mattidragon.jsonpatcher.patch.PatchLoader;
import dev.mattidragon.jsonpatcher.patch.PatchStorage;
import dev.mattidragon.jsonpatcher.patch.Patcher;
import java.io.InputStream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3902;
import net.minecraft.class_7367;

public class PatchingContext {
    private static final ThreadLocal<class_3902> DISABLED = new ThreadLocal();
    private final class_3264 resourceType;
    private boolean loaded = false;
    private Patcher patcher = null;

    public PatchingContext(class_3264 resourceType) {
        this.resourceType = resourceType;
    }

    public static Enabler disablePatching() {
        return new Enabler();
    }

    public void load(class_3300 manager) {
        if (this.loaded) {
            throw new IllegalStateException("Already loaded");
        }
        PatchStorage patches = PatchLoader.loadPatches(Patcher.PATCH_RUNNER, manager, this.resourceType);
        DumpManager.cleanDump(this.resourceType.method_14413());
        JsonPatcher.RELOAD_LOGGER.info("Loaded {} patches for reload {}", (Object)patches.size(), (Object)this.resourceType.name());
        this.patcher = new Patcher(this.resourceType, patches);
        this.patcher.runMetaPatches(manager, Patcher.PATCH_RUNNER);
        this.loaded = true;
    }

    public void patchResource(class_2960 id, class_3298 resource) {
        if (!id.method_12832().endsWith(".json")) {
            return;
        }
        if (DISABLED.get() != null) {
            return;
        }
        if (!this.loaded) {
            throw new IllegalStateException("Context not loaded");
        }
        if (this.patcher.hasPatches(id)) {
            ((ResourceAccess)resource).jsonpatcher$disableKnowPack();
            ((ResourceAccess)resource).jsonpatcher$modifyInputStreamSupplier(stream -> this.patcher.patchInputStream(id, (class_7367<InputStream>)stream));
        }
    }

    public static class Enabler
    implements AutoCloseable {
        private Enabler() {
            DISABLED.set(class_3902.field_17274);
        }

        @Override
        public void close() {
            DISABLED.remove();
        }
    }
}

