/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch.global;

import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.lang.stdlib.Stdlib;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.NotNull;

public class GlobalDirSetup {
    private GlobalDirSetup() {
    }

    public static void setupDirs() {
        try {
            GlobalDirSetup.setupScriptsDir();
            GlobalDirSetup.setupGlobalPatchesDir();
            GlobalDirSetup.dumpDocsDir();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to setup jsonpatcher files", e);
        }
    }

    private static void setupScriptsDir() throws IOException {
        Path scriptsDir = JsonPatcher.DATA_DIR.resolve("scripts");
        boolean exists = Files.exists(scriptsDir, new LinkOption[0]);
        Files.createDirectories(scriptsDir, new FileAttribute[0]);
        String readme = "# JsonPatcher global scripts\nAny jsonpatcher scripts placed here will be loaded on startup.\n\nIf a script has the `@library` meta tag it will be available to all patches\nfrom elsewhere with a prefix of `scripts:global:` for imports.\n\nIf a script has the `@init \"main\";` meta tag it will be executed during mod init.\nIf it has the `@init \"client\";` meta tag it will be executed during client mod init.\n\nUnder default config scripts present here will have access to the reflection library,\nallowing them to interact with Java code freely.\n";
        Files.writeString(scriptsDir.resolve("README.md"), (CharSequence)readme, new OpenOption[0]);
        String workspaceJson = "{\n  \"$schema\": \"https://raw.githubusercontent.com/MattiDragon/JsonPatcherLang/refs/heads/2.0/tools/lang-server/jsonpatcher-workspace.schema.json\",\n  \"schema_version\": 1,\n  \"lang_version\": [2, 0, 0],\n  \"allowed_library_groups\": [\"default\", \"jsonpatcher:reflection\", \"+jsonpatcher:global_scripts\"]\n}\n";
        Files.writeString(scriptsDir.resolve("jsonpatcher-workspace.json"), (CharSequence)workspaceJson, new OpenOption[0]);
        if (exists) {
            return;
        }
        Files.writeString(scriptsDir.resolve("example.jsonpatch"), (CharSequence)"@version \"2\";\n@init \"main\";\n\nimport \"reflection\";\n\nval ResourceLocation = reflection.findClass(\"net.minecraft.resources.ResourceLocation\");\n\nval id1 = ResourceLocation.withDefaultNamespace(\"test_id\");\nval id2 = ResourceLocation.fromNamespaceAndPath(\"minecraft\", \"test_id\");\n\ndebug.assert(id1.equals(id2));\ndebug.log(\"Logging from example global script: \" + strings.asString(id1));\n", new OpenOption[0]);
    }

    private static void setupGlobalPatchesDir() throws IOException {
        Path dir = JsonPatcher.DATA_DIR.resolve("global_patches");
        Files.createDirectories(dir.resolve("data"), new FileAttribute[0]);
        Files.createDirectories(dir.resolve("assets"), new FileAttribute[0]);
        String readme = "# JsonPatcher global patches\nThis directory is intended as a convenient place for modpack developers to place patches.\nPatches from here are automatically loaded together with patches from data- and resourcepacks.\nScripts are loaded straight from the `data` and `assets` subdirectories,\nfor datapack and resourcepack patching respectively.\n\nScripts here have modpack level trust, so they get access to reflection by default.\nBe careful not to make permanent changes to the game state however, as these scripts will run on every\nreload like normal patches.\n";
        Files.writeString(dir.resolve("README.md"), (CharSequence)readme, new OpenOption[0]);
        String dataWorkspaceJson = "{\n  \"$schema\": \"https://raw.githubusercontent.com/MattiDragon/JsonPatcherLang/refs/heads/2.0/tools/lang-server/jsonpatcher-workspace.schema.json\",\n  \"schema_version\": 1,\n  \"lang_version\": [2, 0, 0],\n  \"allowed_library_groups\": [\"default\", \"jsonpatcher:reflection\", \"+minecraft-data\"]\n}\n";
        Files.writeString(dir.resolve("data").resolve("jsonpatcher-workspace.json"), (CharSequence)dataWorkspaceJson, new OpenOption[0]);
        String assetsWorkspaceJson = "{\n  \"$schema\": \"https://raw.githubusercontent.com/MattiDragon/JsonPatcherLang/refs/heads/2.0/tools/lang-server/jsonpatcher-workspace.schema.json\",\n  \"schema_version\": 1,\n  \"lang_version\": [2, 0, 0],\n  \"allowed_library_groups\": [\"default\", \"jsonpatcher:reflection\", \"+minecraft-assets\"]\n}\n";
        Files.writeString(dir.resolve("assets").resolve("jsonpatcher-workspace.json"), (CharSequence)assetsWorkspaceJson, new OpenOption[0]);
    }

    private static void dumpDocsDir() throws IOException {
        Path docsDir = JsonPatcher.DATA_DIR.resolve("docs");
        Files.createDirectories(docsDir, new FileAttribute[0]);
        Path stdlibDir = docsDir.resolve("stdlib");
        Files.createDirectories(stdlibDir, new FileAttribute[0]);
        final Path modDir = docsDir.resolve("mod");
        Files.createDirectories(modDir, new FileAttribute[0]);
        String readme = "# JsonPatcher doc files\nThis directory contains copies of the standard library.\nIt gets regenerated each time the game is launched and modifications won't be respected.\n\nUse this as a reference or let your editor plugins read the doc comments.\n";
        Files.writeString(docsDir.resolve("README.md"), (CharSequence)readme, new OpenOption[0]);
        String workspaceJson = "{\n  \"$schema\": \"https://raw.githubusercontent.com/MattiDragon/JsonPatcherLang/refs/heads/2.0/tools/lang-server/jsonpatcher-workspace.schema.json\",\n  \"schema_version\": 1,\n  \"external_stdlib_needed\": false,\n  \"allowed_library_groups\": [\"default\", \"jsonpatcher:internals\", \"jsonpatcher:reflection\"]\n}\n";
        Files.writeString(docsDir.resolve("jsonpatcher-workspace.json"), (CharSequence)workspaceJson, new OpenOption[0]);
        for (String name : Stdlib.GLOBAL_LIBRARY_NAMES) {
            Files.writeString(stdlibDir.resolve(name + ".jsonpatch"), (CharSequence)Stdlib.LIBRARY_CONTENTS.get(name), new OpenOption[0]);
        }
        for (String name : Stdlib.MISC_LIBRARY_NAMES) {
            Files.writeString(stdlibDir.resolve(name + ".jsonpatch"), (CharSequence)Stdlib.LIBRARY_CONTENTS.get(name), new OpenOption[0]);
        }
        for (String name : Stdlib.DOC_LIBRARY_NAMES) {
            Files.writeString(stdlibDir.resolve(name + ".jsonpatch"), (CharSequence)Stdlib.LIBRARY_CONTENTS.get(name), new OpenOption[0]);
        }
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("jsonpatcher").orElseThrow();
        final Optional internalDocsPath = modContainer.findPath("docs");
        if (internalDocsPath.isPresent()) {
            Files.walkFileTree((Path)internalDocsPath.get(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    Path relativePath = ((Path)internalDocsPath.get()).relativize(file);
                    Path targetPath = modDir.resolve(relativePath.toString());
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

