/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch.global;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.mattidragon.jsonpatcher.JsonPatcher;
import dev.mattidragon.jsonpatcher.config.Config;
import dev.mattidragon.jsonpatcher.lang.ast.meta.MetadataHolder;
import dev.mattidragon.jsonpatcher.lang.ast.meta.MetadataKey;
import dev.mattidragon.jsonpatcher.lang.ast.meta.TreeMetadata;
import dev.mattidragon.jsonpatcher.lang.error.Diagnostic;
import dev.mattidragon.jsonpatcher.lang.error.Diagnostics;
import dev.mattidragon.jsonpatcher.lang.error.DiagnosticsBuilder;
import dev.mattidragon.jsonpatcher.lang.parse.Lexer;
import dev.mattidragon.jsonpatcher.lang.parse.Parser;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataElement;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.MetadataString;
import dev.mattidragon.jsonpatcher.lang.parse.metadata.PatchMetadata;
import dev.mattidragon.jsonpatcher.lang.runtime.bytecode.CompilationException;
import dev.mattidragon.jsonpatcher.lang.runtime.bytecode.compiler.CompilerOptions;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.EvaluationEnvironment;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.Library;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.LibraryGroup;
import dev.mattidragon.jsonpatcher.lang.runtime.environment.ProgramData;
import dev.mattidragon.jsonpatcher.lang.runtime.value.Value;
import dev.mattidragon.jsonpatcher.patch.LibraryMetadata;
import dev.mattidragon.jsonpatcher.patch.PatchLoader;
import dev.mattidragon.jsonpatcher.patch.PatchLoaderDiagnostic;
import dev.mattidragon.jsonpatcher.patch.Patcher;
import dev.mattidragon.jsonpatcher.patch.global.GlobalPatch;
import dev.mattidragon.jsonpatcher.patch.global.GlobalPatchSource;
import dev.mattidragon.jsonpatcher.trust.TrustLevel;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.Nullable;

public class GlobalPatchLoader {
    private static List<Library> globalLibs = new ArrayList<Library>();
    private static List<GlobalPatch> globalPatches = new ArrayList<GlobalPatch>();
    private static final AtomicInteger errorCount = new AtomicInteger();
    private static final AtomicInteger warnCount = new AtomicInteger();

    private static List<GlobalPatchSource> findSources() {
        ArrayList<GlobalPatchSource> sources = new ArrayList<GlobalPatchSource>();
        sources.add(new GlobalPatchSource("scripts:global", JsonPatcher.DATA_DIR.resolve("scripts"), TrustLevel.MODPACK));
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            mod.findPath("jsonpatcher/scripts").ifPresent(path -> sources.add(new GlobalPatchSource("mod:" + mod.getMetadata().getId(), (Path)path, TrustLevel.MOD)));
        }
        return sources;
    }

    public static synchronized void loadGlobalPatches() {
        globalLibs = new ArrayList<Library>();
        globalPatches = new ArrayList<GlobalPatch>();
        warnCount.set(0);
        errorCount.set(0);
        EvaluationEnvironment environment = new EvaluationEnvironment(CompilerOptions.DEFAULT);
        if (((Config)Config.MANAGER.get()).dumpCompiledPatches()) {
            environment.enableDumping(JsonPatcher.DATA_DIR.resolve("dump").resolve("classes").resolve("global"));
        }
        environment.enableLogging(v -> JsonPatcher.RELOAD_LOGGER.debug("Debug from global patch: {}", v));
        environment.bootstrap();
        for (GlobalPatchSource source : GlobalPatchLoader.findSources()) {
            globalPatches.addAll(GlobalPatchLoader.loadPatchDir(source, environment));
        }
        JsonPatcher.RELOAD_LOGGER.info("Loaded {} global patches. ({} libraries)", (Object)globalPatches.size(), (Object)GlobalPatchLoader.getGlobalLibs().size());
        if (warnCount.get() > 0) {
            JsonPatcher.RELOAD_LOGGER.warn("Encountered {} warnings while loading global patches. See jsonpatcher/jsonpatcher.log for details.", (Object)warnCount.get());
        }
        if (errorCount.get() > 0) {
            JsonPatcher.RELOAD_LOGGER.error("Encountered {} errors while loading global patches. See jsonpatcher/jsonpatcher.log for details.", (Object)errorCount.get());
        }
    }

    public static synchronized List<Library> getGlobalLibs() {
        return Collections.unmodifiableList(globalLibs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runEntrypoint(GlobalPatch.Entrypoint entrypoint) {
        Class<GlobalPatchLoader> clazz = GlobalPatchLoader.class;
        synchronized (GlobalPatchLoader.class) {
            List<GlobalPatch> toRun = globalPatches.stream().filter(globalPatch -> globalPatch.entrypoint() == entrypoint).toList();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
            try (ExecutorService executor = Executors.newSingleThreadExecutor();){
                for (GlobalPatch patch : toRun) {
                    Patcher.runPatch(patch, executor, errors::add, new Value.ObjectValue());
                }
            }
            if (!errors.isEmpty()) {
                errors.forEach(error -> JsonPatcher.RELOAD_LOGGER.error("Error while running entrypoint patches for {} entrypoint", (Object)entrypoint, error));
                if (((Config)Config.MANAGER.get()).throwOnFailure()) {
                    throw new RuntimeException("Encountered %s error(s) while running entrypoint patches for %s. See jsonpatcher/jsonpatcher.log for details".formatted(new Object[]{errors.size(), entrypoint}));
                }
                JsonPatcher.MAIN_LOGGER.error("Encountered {} error(s) while running entrypoint patches for {}. See jsonpatcher/jsonpatcher.log for details", (Object)errors.size(), (Object)entrypoint);
            }
            return;
        }
    }

    private static List<GlobalPatch> loadPatchDir(GlobalPatchSource source, EvaluationEnvironment environment) {
        ArrayList<GlobalPatch> patches = new ArrayList<GlobalPatch>();
        try (Stream<Path> stream = Files.walk(source.path(), new FileVisitOption[0]);){
            List<Path> files = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
            for (Path file : files) {
                String code;
                if (!file.toString().endsWith(".jsonpatch")) continue;
                String fileName = source.path().relativize(file).toString();
                String id = source.idPrefix() + ":" + fileName.substring(0, fileName.length() - ".jsonpatch".length()).replace(file.getFileSystem().getSeparator(), "/").replaceFirst("^\\./", "");
                GlobalPatch patch = GlobalPatchLoader.loadPatch(id, code = Files.readString(file), source.trustLevel(), environment);
                if (patch == null) continue;
                patches.add(patch);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load global patches with prefix " + source.idPrefix(), e);
        }
        return patches;
    }

    @Nullable
    private static GlobalPatch loadPatch(String id, String code, TrustLevel trust, EvaluationEnvironment environment) {
        EvaluationEnvironment.AddedProgram added;
        DiagnosticsBuilder diagnosticsBuilder = new DiagnosticsBuilder();
        Lexer.Result lexResult = Lexer.lex((String)code, (String)id, (DiagnosticsBuilder)diagnosticsBuilder);
        Parser.Result parseResult = Parser.parse((List)lexResult.tokens(), (DiagnosticsBuilder)diagnosticsBuilder);
        TreeMetadata treeMeta = parseResult.treeMetadata();
        PatchMetadata meta = parseResult.metadata();
        if (meta.has("enabled") && !meta.getBoolean("enabled")) {
            return null;
        }
        HashSet<String> roles = new HashSet<String>();
        double priority = PatchLoader.getPriority(meta);
        LibraryMetadata libraryMetadata = PatchLoader.getLibraryMetadata(diagnosticsBuilder, meta, treeMeta, roles);
        GlobalPatch.Entrypoint entrypoint = GlobalPatchLoader.getEntrypointMeta(meta, treeMeta, diagnosticsBuilder, roles);
        String className = "jsonpatcher_global/" + id.replaceAll("[-.:]", "_");
        ProgramData.Builder builder = ProgramData.builder((Parser.Result)parseResult).scriptName(id).className(className);
        if (trust.ordinal() >= ((Config)Config.MANAGER.get()).reflectionMinTrustLevel().ordinal()) {
            builder.allowLibraryGroup(LibraryGroup.REFLECTION);
        }
        try {
            added = environment.addProgram(builder.build());
        }
        catch (CompilationException e) {
            diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(null, e.getMessage(), Diagnostic.Kind.ERROR, 20));
            added = null;
        }
        Diagnostics diagnostics = diagnosticsBuilder.build();
        Collection errors = diagnostics.errors();
        if (!errors.isEmpty()) {
            JsonPatcher.RELOAD_LOGGER.error("Errors while loading global patch {}:\n{}", (Object)id, (Object)errors.stream().map(Diagnostic::toDisplay).collect(Collectors.joining("\n")));
            errorCount.incrementAndGet();
            return null;
        }
        Collection warnings = diagnostics.warnings();
        if (!warnings.isEmpty()) {
            JsonPatcher.RELOAD_LOGGER.warn("Warnings while loading global patch {}:\n{}", (Object)id, (Object)warnings.stream().map(Diagnostic::toDisplay).collect(Collectors.joining("\n")));
            warnCount.incrementAndGet();
        }
        if (added == null) {
            return null;
        }
        if (libraryMetadata != null) {
            EvaluationEnvironment.AddedProgram finalAdded = added;
            Supplier supplier = () -> {
                Value.ObjectValue obj = new Value.ObjectValue();
                finalAdded.run(obj);
                return obj;
            };
            if (libraryMetadata.shared()) {
                supplier = Suppliers.memoize(() -> supplier.get());
            }
            Library lib = new Library(LibraryGroup.DEFAULT, id, supplier);
            globalLibs.add(lib);
            environment.addLibrary(lib);
        }
        return new GlobalPatch(added, id, priority, trust, entrypoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static GlobalPatch.Entrypoint getEntrypointMeta(PatchMetadata meta, TreeMetadata treeMeta, DiagnosticsBuilder diagnosticsBuilder, Set<String> roles) {
        String string;
        if (!meta.has("init")) {
            return null;
        }
        roles.add("init");
        MetadataElement metadataElement = meta.get("init");
        if (!(metadataElement instanceof MetadataString)) {
            diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(treeMeta.get((MetadataHolder)meta.get("init"), MetadataKey.MAIN_POS).orElse(null), "@init must be set to string", Diagnostic.Kind.ERROR, 21));
            return null;
        }
        Object object = (MetadataString)metadataElement;
        try {
            String string2;
            string = string2 = object.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        switch (string) {
            case "main": {
                GlobalPatch.Entrypoint entrypoint = GlobalPatch.Entrypoint.MAIN;
                return entrypoint;
            }
            case "client": {
                GlobalPatch.Entrypoint entrypoint = GlobalPatch.Entrypoint.CLIENT;
                return entrypoint;
            }
        }
        diagnosticsBuilder.addDiagnostic((Diagnostic)new PatchLoaderDiagnostic(treeMeta.get((MetadataHolder)meta.get("init"), MetadataKey.MAIN_POS).orElse(null), "Invalid entrypoint: " + string, Diagnostic.Kind.ERROR, 22));
        return null;
    }
}

