/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.patch.global;

import dev.mattidragon.jsonpatcher.JsonPatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class GlobalPatchScanner {
    public static final Path BASE_DIR = JsonPatcher.DATA_DIR.resolve("global_patches");

    private GlobalPatchScanner() {
    }

    public static Map<class_2960, class_7367<InputStream>> scan(class_3264 type) {
        HashMap<class_2960, class_7367<InputStream>> hashMap;
        block8: {
            Path path = BASE_DIR.resolve(type.method_14413());
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                HashMap<class_2960, class_7367<InputStream>> out = new HashMap<class_2960, class_7367<InputStream>>();
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(patchPath -> patchPath.toString().endsWith(".jsonpatch")).forEach(patchPath -> {
                    String fileName = BASE_DIR.relativize((Path)patchPath).toString();
                    String cleanedName = fileName.substring(0, fileName.length() - ".jsonpatch".length()).replace(BASE_DIR.getFileSystem().getSeparator(), "/").replaceFirst("^\\./", "");
                    class_2960 id = class_2960.method_43902((String)"global", (String)("/" + cleanedName));
                    if (id == null) {
                        return;
                    }
                    out.put(id, class_7367.create((Path)patchPath));
                });
                hashMap = out;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    JsonPatcher.MAIN_LOGGER.error("Failed to scan global patches", (Throwable)e);
                    return Map.of();
                }
            }
            stream.close();
        }
        return hashMap;
    }
}

