/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.remap;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import dev.mattidragon.jsonpatcher.JsonPatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.proguard.ProGuardFileReader;
import net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.minecraft.class_3797;

public class MappingsLoader {
    private static final Gson GSON = new Gson();
    private static final Path INTERMEDIARY_DIR = JsonPatcher.DATA_DIR.resolve("cache/mappings/intermediary");
    private static final Path MOJMAP_DIR = JsonPatcher.DATA_DIR.resolve("cache/mappings/mojmap");
    private static final URI MANIFEST_URI;
    public static final MemoryMappingTree MAPPING_TREE;

    public static void init() {
        Path mojmapPath = MOJMAP_DIR.resolve("%s_%s.txt".formatted(class_3797.field_25319.method_48019(), FabricLoader.getInstance().getEnvironmentType().name().toLowerCase(Locale.ROOT)));
        Path intermediaryPath = INTERMEDIARY_DIR.resolve(class_3797.field_25319.method_48019() + ".tiny");
        try {
            if (!Files.exists(mojmapPath, new LinkOption[0])) {
                JsonPatcher.MAIN_LOGGER.info("Downloading mojmap for jsonpatch remapping");
                MappingsLoader.downloadMojmap(mojmapPath);
            }
            if (!Files.exists(intermediaryPath, new LinkOption[0])) {
                JsonPatcher.MAIN_LOGGER.info("Downloading intermediary for jsonpatch remapping");
                MappingsLoader.downloadIntermediary(intermediaryPath);
            }
            MemoryMappingTree loadingTree = new MemoryMappingTree();
            loadingTree.setSrcNamespace("official");
            loadingTree.setDstNamespaces(List.of("intermediary", "named"));
            try (BufferedReader reader = Files.newBufferedReader(intermediaryPath);){
                Tiny2FileReader.read((Reader)reader, (MappingVisitor)loadingTree);
            }
            reader = Files.newBufferedReader(mojmapPath);
            try {
                ProGuardFileReader.read((Reader)reader, (String)"named", (String)"official", (MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)loadingTree, "official"));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            MAPPING_TREE.setSrcNamespace("intermediary");
            MAPPING_TREE.setDstNamespaces(List.of("named"));
            loadingTree.accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)MAPPING_TREE, "intermediary"));
            MAPPING_TREE.setDstNamespaces(List.of("named"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load mappings", e);
        }
    }

    private static void downloadMojmap(Path path) {
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            URI mappingsUrl;
            URI versionJsonUrl;
            Files.createDirectories(MOJMAP_DIR, new FileAttribute[0]);
            HttpResponse<InputStream> versionManifest = httpClient.send(HttpRequest.newBuilder(MANIFEST_URI).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
            try (JsonReader reader = GSON.newJsonReader((Reader)new InputStreamReader(versionManifest.body()));){
                versionJsonUrl = MappingsLoader.extractVersionJsonUrl(reader);
            }
            HttpResponse<InputStream> versionJson = httpClient.send(HttpRequest.newBuilder(versionJsonUrl).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
            try (JsonReader reader = GSON.newJsonReader((Reader)new InputStreamReader(versionJson.body()));){
                mappingsUrl = MappingsLoader.extractMappingsUrl(reader);
            }
            httpClient.send(HttpRequest.newBuilder(mappingsUrl).GET().build(), HttpResponse.BodyHandlers.ofFile(path));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to download mappings", e);
        }
    }

    private static URI extractVersionJsonUrl(JsonReader reader) throws IOException, URISyntaxException {
        reader.beginObject();
        while (!reader.nextName().equals("versions")) {
            reader.skipValue();
        }
        reader.beginArray();
        while (reader.hasNext()) {
            reader.beginObject();
            String id = null;
            String url = null;
            block10: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "id": {
                        id = reader.nextString();
                        continue block10;
                    }
                    case "url": {
                        url = reader.nextString();
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (id == null || url == null || !id.equals(class_3797.field_25319.method_48019())) continue;
            return new URI(url);
        }
        throw new IllegalStateException("Current version missing from manifest");
    }

    private static URI extractMappingsUrl(JsonReader reader) throws IOException, URISyntaxException {
        String target;
        reader.beginObject();
        while (!reader.nextName().equals("downloads")) {
            reader.skipValue();
        }
        reader.beginObject();
        String string = target = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? "client_mappings" : "server_mappings";
        while (reader.hasNext()) {
            if (reader.nextName().equals(target)) {
                reader.beginObject();
                while (!reader.nextName().equals("url")) {
                    reader.skipValue();
                }
                return new URI(reader.nextString());
            }
            reader.skipValue();
        }
        throw new IllegalStateException("Mappings not found in version json");
    }

    private static void downloadIntermediary(Path path) {
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String versionName = class_3797.field_25319.method_48019();
            URI url = new URI("https://maven.fabricmc.net/net/fabricmc/intermediary/%s/intermediary-%s-v2.jar".formatted(versionName, versionName));
            HttpResponse<InputStream> jarResponse = httpClient.send(HttpRequest.newBuilder(url).GET().build(), HttpResponse.BodyHandlers.ofInputStream());
            try (ZipInputStream in = new ZipInputStream(jarResponse.body());){
                while (true) {
                    ZipEntry entry;
                    if ((entry = in.getNextEntry()) == null) {
                        throw new IllegalStateException("Cannot find mappings in yarn jar");
                    }
                    if (!entry.getName().endsWith(".tiny")) continue;
                    Files.copy(in, path, new CopyOption[0]);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to download intermediary mappings", e);
        }
    }

    static {
        MAPPING_TREE = new MemoryMappingTree(true);
        try {
            MANIFEST_URI = new URI("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

