/*
 * Decompiled with CFR 0.152.
 */
package dev.mattidragon.jsonpatcher.remap;

import dev.mattidragon.jsonpatcher.lang.runtime.lib.reflection.remap.Remapper;
import dev.mattidragon.jsonpatcher.remap.MappingsLoader;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.mappingio.tree.MappingTree;
import net.minecraft.class_6319;
import net.minecraft.class_6328;

@class_6319
@class_6328
@ParametersAreNonnullByDefault
public class ReflectionRemapper
implements Remapper {
    private final MappingTree tree = MappingsLoader.MAPPING_TREE;
    private final MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
    private static final int RUNTIME_NAMESPACE = -1;
    private static final int NAMED_NAMESPACE = 0;

    public String remapClassToNamed(String name) {
        return this.tree.mapClassName(this.dotToSlash(this.resolver.unmapClassName("intermediary", this.slashToDot(name))), 0);
    }

    public String remapClassToRuntime(String name) {
        return this.dotToSlash(this.resolver.mapClassName("intermediary", this.slashToDot(this.tree.mapClassName(name, 0, -1))));
    }

    public String remapFieldToRuntime(String owner, String name, String descriptor) {
        MappingTree.ClassMapping clazz = this.tree.getClass(owner, 0);
        if (clazz == null) {
            return name;
        }
        String className = clazz.getName(-1);
        if (className == null) {
            return name;
        }
        MappingTree.FieldMapping field = clazz.getField(name, descriptor, 0);
        if (field == null) {
            return name;
        }
        String fieldName = field.getName(-1);
        if (fieldName == null) {
            return name;
        }
        String fieldDesc = field.getDesc(-1);
        if (fieldDesc == null) {
            return name;
        }
        return this.dotToSlash(this.resolver.mapFieldName("intermediary", this.slashToDot(className), fieldName, fieldDesc));
    }

    public String remapMethodToRuntime(String owner, String name, String descriptor) {
        MappingTree.ClassMapping clazz = this.tree.getClass(owner, 0);
        if (clazz == null) {
            return name;
        }
        String className = clazz.getName(-1);
        if (className == null) {
            return name;
        }
        MappingTree.MethodMapping method = clazz.getMethod(name, descriptor, 0);
        if (method == null) {
            return name;
        }
        String methodName = method.getName(-1);
        if (methodName == null) {
            return name;
        }
        String methodDesc = method.getDesc(-1);
        if (methodDesc == null) {
            return name;
        }
        return this.dotToSlash(this.resolver.mapMethodName("intermediary", this.slashToDot(className), methodName, methodDesc));
    }

    private String slashToDot(String name) {
        return name.replace('/', '.');
    }

    private String dotToSlash(String name) {
        return name.replace('.', '/');
    }
}

