/*
 * Decompiled with CFR 0.152.
 */
package craftkaisen;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TerrainFlattener {
    public static void destroyOneLayerAround(ServerLevel level, BlockPos center, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int z;
                int topY;
                int x = center.m_123341_() + dx;
                BlockPos targetPos = new BlockPos(x, topY = TerrainFlattener.getTopSolidY((Level)level, x, z = center.m_123343_() + dz), z);
                BlockState state = level.m_8055_(targetPos);
                if (TerrainFlattener.isDecorativeSurfaceBlock(state)) {
                    targetPos = targetPos.m_7495_();
                    state = level.m_8055_(targetPos);
                }
                float hardness = state.m_60800_((BlockGetter)level, targetPos);
                if (state.m_60795_() || !(hardness >= 0.0f) || !(hardness < 2.5f)) continue;
                level.m_46961_(targetPos, true);
            }
        }
    }

    private static int getTopSolidY(Level level, int x, int z) {
        int maxY = level.m_151558_();
        for (int y = maxY - 1; y >= level.m_141937_(); --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (level.m_8055_(pos).m_60795_()) continue;
            return y;
        }
        return level.m_141937_();
    }

    private static boolean isDecorativeSurfaceBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_) || state.m_204336_(BlockTags.f_13041_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_) || state.m_60713_(Blocks.f_50036_);
    }
}

