/*
 * Decompiled with CFR 0.152.
 */
package craftkaisen.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DomainExpansionTicker {
    private static final Map<UUID, DomainData> activeDomains = new HashMap<UUID, DomainData>();

    public static void addDomain(UUID playerId, ServerLevel level, Map<BlockPos, BlockState> savedBlocks) {
        activeDomains.put(playerId, new DomainData(level, savedBlocks, 300));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<UUID, DomainData>> iterator = activeDomains.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, DomainData> entry = iterator.next();
            DomainData data = entry.getValue();
            --data.ticksRemaining;
            if (data.ticksRemaining > 0) continue;
            DomainExpansionTicker.revertDomain(data);
            iterator.remove();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerId = event.getEntity().m_20148_();
        if (activeDomains.containsKey(playerId)) {
            DomainExpansionTicker.revertDomain(activeDomains.get(playerId));
            activeDomains.remove(playerId);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        UUID playerId = event.getEntity().m_20148_();
        if (activeDomains.containsKey(playerId)) {
            DomainExpansionTicker.revertDomain(activeDomains.get(playerId));
            activeDomains.remove(playerId);
        }
    }

    private static void revertDomain(DomainData data) {
        for (Map.Entry<BlockPos, BlockState> block : data.savedBlocks.entrySet()) {
            data.level.m_46597_(block.getKey(), block.getValue());
        }
    }

    private static class DomainData {
        ServerLevel level;
        Map<BlockPos, BlockState> savedBlocks;
        int ticksRemaining;

        DomainData(ServerLevel level, Map<BlockPos, BlockState> savedBlocks, int ticksRemaining) {
            this.level = level;
            this.savedBlocks = savedBlocks;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

