/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.entity;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.povstalec.sgjourney.common.entities.Goauld;

public class GoauldModel<T extends Goauld>
extends HierarchicalModel<T> {
    private static final int BODY_COUNT = 7;
    private final ModelPart root;
    private final ModelPart[] bodyParts = new ModelPart[7];
    private static final int[][] BODY_SIZES = new int[][]{{2, 2, 3}, {2, 2, 3}, {2, 2, 3}, {2, 2, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
    private static final int[][] BODY_TEXS = new int[][]{{0, 0}, {0, 5}, {0, 10}, {0, 15}, {0, 20}, {10, 0}, {10, 3}};

    public GoauldModel(ModelPart part) {
        this.root = part;
        Arrays.setAll(this.bodyParts, id -> part.getChild(GoauldModel.getSegmentName(id)));
    }

    private static String getSegmentName(int id) {
        return "segment" + id;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float[] afloat = new float[7];
        float f = -3.5f;
        for (int i = 0; i < 7; ++i) {
            partdefinition.addOrReplaceChild(GoauldModel.getSegmentName(i), CubeListBuilder.create().texOffs(BODY_TEXS[i][0], BODY_TEXS[i][1]).addBox((float)BODY_SIZES[i][0] * -0.5f, 0.0f, (float)BODY_SIZES[i][2] * -0.5f, (float)BODY_SIZES[i][0], (float)BODY_SIZES[i][1], (float)BODY_SIZES[i][2]), PartPose.offset((float)0.0f, (float)(24 - BODY_SIZES[i][1]), (float)f));
            afloat[i] = f;
            if (i >= 6) continue;
            f += (float)(BODY_SIZES[i][2] + BODY_SIZES[i + 1][2]) * 0.5f;
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T goauld, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i].yRot = Mth.cos((float)(ageInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
            this.bodyParts[i].x = Mth.sin((float)(ageInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
        }
    }
}

