/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.ClientUtil;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.SymbolBlockEntity;
import net.povstalec.sgjourney.common.blocks.SymbolBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import org.joml.Matrix4f;

public abstract class SymbolBlockRenderer {
    private static final ResourceLocation ERROR = StargateJourney.sgjourneyLocation("textures/symbols/error.png");
    protected static final float SYMBOL_OFFSET = 0.51f;
    protected static final float SYMBOL_SIZE = 1.0f;
    protected static final float SYMBOL_START = -0.5f;
    protected static final float SYMBOL_END = 0.5f;
    protected int red;
    protected int green;
    protected int blue;

    public SymbolBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected PointOfOrigin getPointOfOrigin(SymbolBlockEntity symbolBlock) {
        return ClientUtil.getPointOfOrigin(symbolBlock.pointOfOrigin);
    }

    protected Symbols getSymbols(SymbolBlockEntity symbolBlock) {
        return ClientUtil.getSymbols(symbolBlock.symbols);
    }

    protected void renderSymbol(VertexConsumer consumer, Matrix4f matrix4, PoseStack.Pose pose, int light, float textureSize, float textureOffset) {
        float textureHalf = 1.0f / textureSize / 2.0f;
        consumer.addVertex(matrix4, -0.5f, 0.5f, 0.51f).setColor((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).setUv(textureOffset - textureHalf, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(light, light >> 16).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix4, -0.5f, -0.5f, 0.51f).setColor((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).setUv(textureOffset - textureHalf, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(light, light >> 16).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix4, 0.5f, -0.5f, 0.51f).setColor((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).setUv(textureOffset + textureHalf, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(light, light >> 16).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix4, 0.5f, 0.5f, 0.51f).setColor((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).setUv(textureOffset + textureHalf, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(light, light >> 16).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    protected void renderSymbolBlock(SymbolBlockEntity symbolBlock, PoseStack stack, MultiBufferSource source, int light) {
        BlockState blockstate = symbolBlock.getBlockState();
        float facing = ((Direction)blockstate.getValue((Property)SymbolBlock.FACING)).toYRot();
        Direction direction = (Direction)blockstate.getValue((Property)SymbolBlock.FACING);
        Orientation orientation = (Orientation)((Object)blockstate.getValue(SymbolBlock.ORIENTATION));
        BlockPos pos = symbolBlock.getBlockPos().relative(Orientation.getForwardDirection(direction, orientation));
        stack.pushPose();
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose(Axis.YP.rotationDegrees(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        if (symbolBlock != null) {
            Matrix4f matrix4 = stack.last().pose();
            PoseStack.Pose pose = stack.last();
            light = LevelRenderer.getLightColor((BlockAndTintGetter)symbolBlock.getLevel(), (BlockPos)pos);
            if (symbolBlock.symbolNumber == 0) {
                PointOfOrigin pointOfOrigin = this.getPointOfOrigin(symbolBlock);
                ResourceLocation texture = pointOfOrigin != null ? pointOfOrigin.texture() : ERROR;
                VertexConsumer consumer = source.getBuffer(SGJourneyRenderTypes.symbol(texture));
                this.renderSymbol(consumer, matrix4, pose, light, 1.0f, 0.5f);
            } else {
                Symbols symbols = this.getSymbols(symbolBlock);
                if (symbols != null) {
                    ResourceLocation texture = symbols.getSymbolTexture();
                    VertexConsumer consumer = source.getBuffer(SGJourneyRenderTypes.symbol(texture));
                    this.renderSymbol(consumer, matrix4, pose, light, symbols.getSize(), symbols.getTextureOffset(symbolBlock.symbolNumber));
                }
            }
        }
        stack.popPose();
    }

    public static class RedSandstone
    extends SymbolBlockRenderer
    implements BlockEntityRenderer<SymbolBlockEntity.RedSandstone> {
        public RedSandstone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 159;
            this.green = 78;
            this.blue = 11;
        }

        public void render(SymbolBlockEntity.RedSandstone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderSymbolBlock(symbol, stack, source, combinedLight);
        }
    }

    public static class Sandstone
    extends SymbolBlockRenderer
    implements BlockEntityRenderer<SymbolBlockEntity.Sandstone> {
        public Sandstone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 198;
            this.green = 174;
            this.blue = 113;
        }

        public void render(SymbolBlockEntity.Sandstone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderSymbolBlock(symbol, stack, source, combinedLight);
        }
    }

    public static class Stone
    extends SymbolBlockRenderer
    implements BlockEntityRenderer<SymbolBlockEntity.Stone> {
        public Stone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 90;
            this.green = 89;
            this.blue = 90;
        }

        public void render(SymbolBlockEntity.Stone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderSymbolBlock(symbol, stack, source, combinedLight);
        }
    }
}

