/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import org.joml.Matrix4f;

public class PlasmaProjectileRenderer
extends EntityRenderer<PlasmaProjectile> {
    public static final int MAX_LIGHT = 0xF000E0;
    public static final float SIZE = 0.5f;
    private static final ResourceLocation TEXTURE_LOCATION = StargateJourney.sgjourneyLocation("textures/entity/jaffa_staff_weapon_plasma.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_LOCATION);

    public PlasmaProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PlasmaProjectile projectile, float p_114081_, float partialTick, PoseStack stack, MultiBufferSource source, int light) {
        stack.pushPose();
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose posestack$pose = stack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        VertexConsumer vertexconsumer = source.getBuffer(RENDER_TYPE);
        PlasmaProjectileRenderer.vertex(vertexconsumer, matrix4f, posestack$pose, -0.5f, -0.5f, 0.0f, 1.0f);
        PlasmaProjectileRenderer.vertex(vertexconsumer, matrix4f, posestack$pose, 0.5f, -0.5f, 1.0f, 1.0f);
        PlasmaProjectileRenderer.vertex(vertexconsumer, matrix4f, posestack$pose, 0.5f, 0.5f, 1.0f, 0.0f);
        PlasmaProjectileRenderer.vertex(vertexconsumer, matrix4f, posestack$pose, -0.5f, 0.5f, 0.0f, 0.0f);
        stack.popPose();
        super.render((Entity)projectile, p_114081_, partialTick, stack, source, light);
    }

    public static void vertex(VertexConsumer consumer, Matrix4f matrix4f, PoseStack.Pose pose, float x, float y, float u, float v) {
        consumer.addVertex(matrix4f, x, y + 0.125f, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0xF000E0, 240).setNormal(pose, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getTextureLocation(PlasmaProjectile projectile) {
        return TEXTURE_LOCATION;
    }
}

