/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.sound.StargateSoundWrapper;
import net.povstalec.sgjourney.client.sound.sounds.GenericStargateSound;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public class SoundAccess {
    public static final String EMPTY = StargateJourney.EMPTY;
    protected static Minecraft minecraft = Minecraft.getInstance();

    public static void playWormholeOpenSound(BlockPos pos, boolean incoming) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getWormholeOpenSound(stargate, incoming), 0.75f);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    public static void playWormholeIdleSound(BlockPos pos, boolean incoming) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.wormholeIdleSound == null || !stargate.wormholeIdleSound.hasSound()) {
                stargate.wormholeIdleSound = new StargateSoundWrapper.WormholeIdle(stargate, incoming);
            }
            stargate.playWormholeIdleSound();
        }
    }

    public static void playWormholeCloseSound(BlockPos pos, boolean incoming) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getWormholeCloseSound(stargate, incoming), 0.75f);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    public static void playIrisThudSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, (SoundEvent)SoundInit.IRIS_THUD.get(), 0.75f);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void playChevronSound(BlockPos pos, short chevron, boolean incoming, boolean open, boolean encode) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (!(blockEntity instanceof AbstractStargateEntity)) return;
        AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
        if (stargate instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
            if (open || encode) {
                if (open) {
                    GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronOpenSound(milkyWayStargate, chevron), 0.5f);
                    minecraft.getSoundManager().play((SoundInstance)sound);
                    return;
                }
                if (!encode) return;
                GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronEncodeSound(milkyWayStargate, chevron), 0.5f);
                minecraft.getSoundManager().play((SoundInstance)sound);
                return;
            }
        }
        if (incoming) {
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronIncomingSound(stargate, chevron), 0.5f);
            minecraft.getSoundManager().play((SoundInstance)sound);
            return;
        }
        GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronEngageSound(stargate, chevron), 0.5f);
        minecraft.getSoundManager().play((SoundInstance)sound);
    }

    public static void playFailSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getFailSound(stargate, StargateInfo.Feedback.UNKNOWN_ERROR), 0.5f);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    public static void playRotationSound(BlockPos pos, boolean stop) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.spinSound == null) {
                if (stargate instanceof RotatingStargateEntity) {
                    RotatingStargateEntity rotatingStargate = (RotatingStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.RingRotation(rotatingStargate);
                } else if (stargate instanceof PegasusStargateEntity) {
                    PegasusStargateEntity pegasusStargate = (PegasusStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.PegasusRingRotation(pegasusStargate);
                }
            }
            if (stop) {
                stargate.stopRotationSound();
            } else {
                stargate.playRotationSound();
            }
        }
    }

    public static void playUniverseDialStartSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof UniverseStargateEntity) {
            UniverseStargateEntity stargate = (UniverseStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getDialStartSound(stargate), 0.75f);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    public static void playRotationStartupSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof RotatingStargateEntity) {
            RotatingStargateEntity stargate = (RotatingStargateEntity)blockEntity;
            if (stargate.buildupSound == null || !stargate.buildupSound.hasSound()) {
                stargate.buildupSound = new StargateSoundWrapper.RotationStartup(stargate);
            }
            stargate.playBuildupSound();
        }
    }

    public static void playRotationStopSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof RotatingStargateEntity) {
            RotatingStargateEntity stargate = (RotatingStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getRotationStopSound(stargate), 0.75f);
            minecraft.getSoundManager().play((SoundInstance)sound);
        }
    }

    private static SoundEvent getChevronEngageSound(AbstractStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).chevronEngagedSounds().getSound(chevron));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).chevronEngagedSounds().getSound(chevron));
    }

    private static SoundEvent getChevronOpenSound(MilkyWayStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargateVariant.get().clientVariant()).chevronOpenSounds().getSound(chevron));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargate.defaultVariant()).chevronOpenSounds().getSound(chevron));
    }

    private static SoundEvent getChevronEncodeSound(MilkyWayStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargateVariant.get().clientVariant()).chevronEncodeSounds().getSound(chevron));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargate.defaultVariant()).chevronEncodeSounds().getSound(chevron));
    }

    private static SoundEvent getChevronIncomingSound(AbstractStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).chevronIncomingSounds().getSound(chevron));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).chevronIncomingSounds().getSound(chevron));
    }

    public static SoundEvent getDialStartSound(UniverseStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getUniverseStargateVariant(stargateVariant.get().clientVariant()).dialStartSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getUniverseStargateVariant(stargate.defaultVariant()).dialStartSound());
    }

    public static SoundEvent getRotationStartupSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargateVariant.get().clientVariant(), stargate).rotationSounds().rotationStartupSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargate.defaultVariant(), stargate).rotationSounds().rotationStartupSound());
    }

    public static SoundEvent getRotationSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargateVariant.get().clientVariant(), stargate).rotationSounds().rotationSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargate.defaultVariant(), stargate).rotationSounds().rotationSound());
    }

    public static SoundEvent getRotationStopSound(RotatingStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargateVariant.get().clientVariant(), stargate).rotationSounds().rotationStopSound());
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargate.defaultVariant(), stargate).rotationSounds().rotationStopSound());
    }

    private static SoundEvent getFailSound(AbstractStargateEntity stargate, StargateInfo.Feedback stargateFeedback) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).failSounds().getSound(stargateFeedback));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).failSounds().getSound(stargateFeedback));
    }

    private static SoundEvent getWormholeOpenSound(AbstractStargateEntity stargate, boolean incoming) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).wormholeSounds().getOpenSound(incoming));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).wormholeSounds().getOpenSound(incoming));
    }

    public static SoundEvent getWormholeIdleSound(AbstractStargateEntity stargate, boolean incoming) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).wormholeSounds().getIdleSound(incoming));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).wormholeSounds().getIdleSound(incoming));
    }

    private static SoundEvent getWormholeCloseSound(AbstractStargateEntity stargate, boolean incoming) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).wormholeSounds().getCloseSound(incoming));
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).wormholeSounds().getCloseSound(incoming));
    }
}

