/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.packets.ClientboundCartoucheUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.AddressTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CartoucheEntity
extends BlockEntity
implements StructureGenEntity {
    public static final String ADDRESS_TABLE = "address_table";
    public static final String DIMENSION = "dimension";
    public static final String GALAXY = "galaxy";
    public static final String SYMBOLS = "symbols";
    public static final String ADDRESS = "address";
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    private ResourceLocation addressTable;
    private ResourceLocation symbols;
    @Nullable
    private Address address;

    public CartoucheEntity(BlockEntityType<?> cartouche, BlockPos pos, BlockState state) {
        super(cartouche, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
        this.generateAddress();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.getByte("generation_step"));
        }
        if (tag.contains(ADDRESS_TABLE)) {
            this.addressTable = ResourceLocation.tryParse((String)tag.getString(ADDRESS_TABLE));
        }
        if (tag.contains(SYMBOLS)) {
            this.symbols = ResourceLocation.tryParse((String)tag.getString(SYMBOLS));
        }
        if (tag.contains(DIMENSION)) {
            this.address = tag.contains(GALAXY) ? new Address.Dimension(Conversion.stringToDimension(tag.getString(DIMENSION)), Optional.of(Conversion.stringToGalaxyKey(tag.getString(GALAXY)))) : new Address.Dimension(Conversion.stringToDimension(tag.getString(DIMENSION)), Optional.empty());
        } else if (tag.contains(ADDRESS)) {
            this.address = new Address.Immutable(tag.getIntArray(ADDRESS));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        Address address;
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.putByte("generation_step", this.generationStep.byteValue());
        }
        if (this.addressTable != null) {
            tag.putString(ADDRESS_TABLE, this.addressTable.toString());
        }
        if (this.symbols != null) {
            tag.putString(SYMBOLS, this.symbols.toString());
        }
        if ((address = this.address) instanceof Address.Dimension) {
            Address.Dimension dimensionAddress = (Address.Dimension)address;
            tag.putString(DIMENSION, dimensionAddress.getDimension().location().toString());
            if (dimensionAddress.getGalaxy() != null) {
                tag.putString(GALAXY, dimensionAddress.getGalaxy().location().toString());
            }
        } else if (this.address != null) {
            tag.putIntArray(ADDRESS, this.address.toArray());
        }
        super.saveAdditional(tag, registries);
    }

    public void setDimension(ResourceLocation dimension) {
        this.address = new Address.Dimension(Conversion.locationToDimension(dimension), Optional.empty());
    }

    public void setSymbols(ResourceLocation symbols) {
        this.symbols = symbols;
    }

    public ResourceLocation getSymbols() {
        return this.symbols;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        if (this.address == null) {
            return new Address.Immutable();
        }
        return this.address;
    }

    public ResourceLocation getAddressTable() {
        return this.addressTable;
    }

    public void setAddressFromAddressTable() {
        AddressTable addressTable = AddressTable.getAddressTable(this.level, this.addressTable);
        Address address = AddressTable.randomAddress(this.level.getServer(), addressTable);
        if (address != null) {
            this.setAddress(address);
        }
        this.addressTable = null;
        this.setChanged();
    }

    public void generateAddress() {
        Address address = this.address;
        if (address instanceof Address.Dimension) {
            Address.Dimension dimensionAddress = (Address.Dimension)address;
            dimensionAddress.generate(this.level.getServer());
        }
    }

    public void setSymbolsFromLevel(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.setSymbols(Universe.get(level).getSymbols((ResourceKey<Level>)level.dimension()).location());
    }

    public void setDimensionFromLevel(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.setDimension(level.dimension().location());
    }

    protected void updateClient() {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundCartoucheUpdatePacket(this.worldPosition, this.symbols == null ? StargateJourney.EMPTY_LOCATION : this.symbols, this.address != null ? this.address.toArray() : new int[]{}), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (state.getValue(CartoucheBlock.HALF) == DoubleBlockHalf.LOWER) {
            this.updateClient();
        }
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    public void generate() {
        if (this.addressTable != null) {
            this.setAddressFromAddressTable();
        }
        if (this.symbols == null) {
            this.setSymbolsFromLevel(this.level);
        }
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }

    public static class RedSandstone
    extends CartoucheEntity {
        public RedSandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.RED_SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Sandstone
    extends CartoucheEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Stone
    extends CartoucheEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_CARTOUCHE.get(), pos, state);
        }
    }
}

