/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.packets.ClientboundSymbolUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class SymbolBlockEntity
extends BlockEntity {
    public static final String SYMBOL = "symbol";
    public static final String SYMBOLS = "symbols";
    public static final String SYMBOL_NUMBER = "symbol_number";
    public static final ResourceLocation EMPTY = StargateJourney.EMPTY_LOCATION;
    private boolean isNew = false;
    public int symbolNumber = 0;
    public ResourceLocation pointOfOrigin = EMPTY;
    public ResourceLocation symbols = EMPTY;

    public SymbolBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.isNew) {
            if (this.pointOfOrigin.equals((Object)EMPTY)) {
                this.setPointOfOrigin(this.level);
            }
            if (this.symbols.equals((Object)EMPTY)) {
                this.setSymbols(this.level);
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(SYMBOL_NUMBER)) {
            this.symbolNumber = tag.getInt(SYMBOL_NUMBER);
        }
        if (tag.contains(SYMBOL)) {
            this.pointOfOrigin = ResourceLocation.tryParse((String)tag.getString(SYMBOL));
        }
        if (tag.contains(SYMBOLS)) {
            this.symbols = ResourceLocation.tryParse((String)tag.getString(SYMBOLS));
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt(SYMBOL_NUMBER, this.symbolNumber);
        if (this.pointOfOrigin != null) {
            tag.putString(SYMBOL, this.pointOfOrigin.toString());
        }
        if (this.symbols != null) {
            tag.putString(SYMBOLS, this.symbols.toString());
        }
        super.saveAdditional(tag, registries);
    }

    public void setNew() {
        this.isNew = true;
    }

    public int getSymbolNumber() {
        return this.symbolNumber;
    }

    public void setPointOfOrigin(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.pointOfOrigin = Universe.get(level).getPointOfOrigin((ResourceKey<Level>)level.dimension()).location();
    }

    public ResourceLocation getPointOfOrigin() {
        return this.pointOfOrigin;
    }

    public void setSymbols(Level level) {
        if (level.isClientSide()) {
            return;
        }
        this.symbols = Universe.get(level).getSymbols((ResourceKey<Level>)level.dimension()).location();
    }

    public ResourceLocation getSymbols() {
        return this.symbols;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundSymbolUpdatePacket(this.worldPosition, this.symbolNumber, this.pointOfOrigin, this.symbols), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static class RedSandstone
    extends SymbolBlockEntity {
        public RedSandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.RED_SANDSTONE_SYMBOL.get(), pos, state);
        }
    }

    public static class Sandstone
    extends SymbolBlockEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_SYMBOL.get(), pos, state);
        }
    }

    public static class Stone
    extends SymbolBlockEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_SYMBOL.get(), pos, state);
        }
    }
}

