/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.config.CommonPermissionConfig;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.CallForwardingDevice;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.CommunicationCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.ControlCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.EnergyCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.MemoryCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.TransferCrystalItem;
import org.jetbrains.annotations.NotNull;

public abstract class CrystalDHDEntity
extends AbstractDHDEntity {
    public static final String CRYSTAL_INVENTORY = "crystal_inventory";
    protected AbstractCrystalItem.Storage memoryCrystals = new AbstractCrystalItem.Storage();
    protected AbstractCrystalItem.Storage controlCrystals = new AbstractCrystalItem.Storage();
    protected AbstractCrystalItem.Storage energyCrystals = new AbstractCrystalItem.Storage();
    protected AbstractCrystalItem.Storage transferCrystals = new AbstractCrystalItem.Storage();
    protected AbstractCrystalItem.Storage communicationCrystals = new AbstractCrystalItem.Storage();
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final Lazy<IItemHandler> handler = Lazy.of(() -> this.itemHandler);

    public CrystalDHDEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state) {
        super(blockEntity, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.itemHandler.deserializeNBT(registries, nbt.getCompound(CRYSTAL_INVENTORY));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put(CRYSTAL_INVENTORY, (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(nbt, registries);
    }

    @Override
    public void onLoad() {
        if (!this.getLevel().isClientSide()) {
            this.recalculateCrystals();
        }
        super.onLoad();
    }

    @Override
    public void invalidateCapabilities() {
        this.handler.invalidate();
        super.invalidateCapabilities();
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.handler.get();
    }

    @Nullable
    public IItemHandler getItemHandler(Direction side) {
        if (!this.isProtected() || CommonPermissionConfig.protected_inventory_access.get()) {
            return (IItemHandler)this.handler.get();
        }
        return null;
    }

    protected ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                CrystalDHDEntity.this.setChanged();
                CrystalDHDEntity.this.recalculateCrystals();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return CrystalDHDEntity.this.isValidCrystal(slot, stack) || stack.getItem() instanceof CallForwardingDevice;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected boolean isValidCrystal(int slot, ItemStack stack) {
        if (slot == 0) {
            AbstractCrystalItem crystal;
            Item item = stack.getItem();
            return item instanceof AbstractCrystalItem && (crystal = (AbstractCrystalItem)item).isLarge();
        }
        return stack.getItem() instanceof AbstractCrystalItem || stack.getItem() instanceof CallForwardingDevice;
    }

    public void recalculateCrystals() {
        this.enableCallForwarding = false;
        this.enableAdvancedProtocols = !this.itemHandler.getStackInSlot(0).isEmpty();
        this.memoryCrystals.reset();
        this.controlCrystals.reset();
        this.energyCrystals.reset();
        this.transferCrystals.reset();
        this.energyTarget = 0L;
        this.maxEnergyTransfer = 0;
        this.communicationCrystals.reset();
        for (int i = 1; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            Item item = stack.getItem();
            if (item instanceof ControlCrystalItem) {
                ControlCrystalItem controlCrystal = (ControlCrystalItem)item;
                this.controlCrystals.addCrystal(controlCrystal.isAdvanced(), i);
                continue;
            }
            if (item instanceof MemoryCrystalItem) {
                MemoryCrystalItem memoryCrystal = (MemoryCrystalItem)item;
                this.memoryCrystals.addCrystal(memoryCrystal.isAdvanced(), i);
                continue;
            }
            if (item instanceof EnergyCrystalItem) {
                EnergyCrystalItem energyCrystal = (EnergyCrystalItem)item;
                this.energyCrystals.addCrystal(energyCrystal.isAdvanced(), i);
                if (this.energyCrystals.getCrystals().length >= 4 || this.energyCrystals.getAdvancedCrystals().length >= 3) {
                    this.energyTarget = -1L;
                    continue;
                }
                if (this.energyTarget < 0L) continue;
                this.energyTarget += energyCrystal.energyTargetIncrease();
                continue;
            }
            if (item instanceof TransferCrystalItem) {
                TransferCrystalItem transferCrystal = (TransferCrystalItem)item;
                this.transferCrystals.addCrystal(transferCrystal.isAdvanced(), i);
                if (this.transferCrystals.getCrystals().length >= 4 || this.transferCrystals.getAdvancedCrystals().length >= 3) {
                    this.maxEnergyTransfer = -1;
                    continue;
                }
                if (this.maxEnergyTransfer < 0) continue;
                this.maxEnergyTransfer = (int)((long)this.maxEnergyTransfer + transferCrystal.getMaxTransfer());
                continue;
            }
            if (item instanceof CommunicationCrystalItem) {
                CommunicationCrystalItem communicationCrystal = (CommunicationCrystalItem)item;
                this.communicationCrystals.addCrystal(communicationCrystal.isAdvanced(), i);
                continue;
            }
            if (!(item instanceof CallForwardingDevice)) continue;
            this.enableCallForwarding = true;
        }
        this.setStargate();
    }

    @Override
    public int getMaxDistance() {
        int regularDistance = this.communicationCrystals.getCrystals().length * ((CommunicationCrystalItem)((Object)ItemInit.COMMUNICATION_CRYSTAL.get())).getMaxDistance();
        int advancedDistance = this.communicationCrystals.getAdvancedCrystals().length * ((CommunicationCrystalItem)((Object)ItemInit.ADVANCED_COMMUNICATION_CRYSTAL.get())).getMaxDistance();
        return 16 + regularDistance + advancedDistance;
    }

    @Override
    public void generate() {
        this.generateCrystals();
        super.generate();
    }

    protected abstract void generateCrystals();
}

