/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AdvancedCrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.BasicInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blocks.tech_interface.AbstractInterfaceBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonPermissionConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.DamageSourceInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundStargateParticleSpawnPacket;
import net.povstalec.sgjourney.common.packets.ClientboundStargateStateUpdatePacket;
import net.povstalec.sgjourney.common.packets.ClientboundStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Dialing;
import net.povstalec.sgjourney.common.sgjourney.ITransmissionReceiver;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateBlockCover;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.info.AddressFilterInfo;
import net.povstalec.sgjourney.common.sgjourney.info.DHDInfo;
import net.povstalec.sgjourney.common.sgjourney.info.SymbolInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStargateEntity
extends EnergyBlockEntity
implements ITransmissionReceiver,
StructureGenEntity,
SymbolInfo.Interface,
DHDInfo.Interface,
AddressFilterInfo.Interface,
ProtectedBlockEntity {
    public static final String EMPTY = StargateJourney.EMPTY;
    public static final String ID_9_CHEVRON_ADDRESS = "9_hevron_address";
    public static final String EVENT_STARGATE_ROTATION_STARTED = "stargate_rotation_started";
    public static final String EVENT_STARGATE_ROTATION_STOPPED = "stargate_rotation_stopped";
    public static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    public static final String EVENT_RESET = "stargate_reset";
    public static final String EVENT_MESSAGE_RECEIVED = "stargate_message_received";
    public static final String ADDRESS = "address";
    public static final String ENERGY = "energy";
    public static final String CONNECTION_STATE = "connection_state";
    public static final String CONNECTION_ID = "connection_id";
    public static final String NETWORK = "network";
    public static final String RESTRICT_NETWORK = "restrict_network";
    public static final String TIMES_OPENED = "times_opened";
    public static final String AUTOCLOSE = "autoclose";
    public static final String UPGRADED = "upgraded";
    public static final String DISPLAY_ID = "display_id";
    public static final String VARIANT = "variant";
    public static final String LOCAL_POINT_OF_ORIGIN = "local_point_of_origin";
    public static final String PRIMARY = "primary";
    public static final String POINT_OF_ORIGIN = "point_of_origin";
    public static final String SYMBOLS = "symbols";
    public static final String COVER_BLOCKS = "cover_blocks";
    public static final String IRIS_INVENTORY = "iris_inventory";
    public static final String SHIELD_INVENTORY = "shield_inventory";
    public static final boolean FORCE_LOAD_CHUNK = (Boolean)CommonStargateConfig.stargate_loads_chunk_when_connected.get();
    public static final int SEGMENTS = 3;
    public static final int MAX_SYMBOLS = 48;
    public static final float STANDARD_THICKNESS = 9.0f;
    public static final float VERTICAL_CENTER_STANDARD_HEIGHT = 0.5f;
    public static final float HORIZONTAL_CENTER_STANDARD_HEIGHT = 0.28125f;
    private static final ResourceLocation CAVUM_TENEBRAE = ResourceLocation.tryBuild((String)"sgjourney", (String)"cavum_tenebrae");
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    protected Address.Immutable id9ChevronAddress = new Address.Immutable();
    protected final StargateInfo.Gen generation;
    protected int totalSymbols;
    protected int[] symbolMap;
    protected int network;
    protected boolean restrictNetwork = false;
    protected BlockPos centerPosition;
    protected Direction direction;
    protected Orientation orientation;
    protected StargateInfo.Feedback recentFeedback = StargateInfo.Feedback.NONE;
    protected int kawooshTick = 0;
    protected int animationTick = 0;
    protected int[] engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
    protected int timesOpened = 0;
    protected int openTime = 0;
    protected int timeSinceLastTraveler = 0;
    protected ResourceLocation variant = StargateJourney.EMPTY_LOCATION;
    private final ResourceLocation defaultVariant;
    protected Address.Mutable address = new Address.Mutable();
    @Nullable
    protected UUID connectionID = null;
    protected StargateConnection.State connectionState = StargateConnection.State.IDLE;
    protected int openSoundLead = 28;
    protected float verticalCenterHeight;
    protected float horizontalCenterHeight;
    @Nullable
    public SoundWrapper wormholeIdleSound = null;
    @Nullable
    public SoundWrapper wormholeOpenSound = null;
    @Nullable
    public SoundWrapper spinSound = null;
    protected boolean displayID = false;
    protected boolean upgraded = false;
    protected boolean localPointOfOrigin = false;
    protected boolean isPrimary = false;
    protected boolean isProtected = false;
    private boolean initialClientSync = false;
    public StargateBlockCover blockCover = new StargateBlockCover(StargatePart.DEFAULT_PARTS);
    protected SymbolInfo symbolInfo;
    protected DHDInfo dhdInfo;
    protected AddressFilterInfo addressFilterInfo;

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork, float verticalCenterHeight, float horizontalCenterHeight) {
        super(blockEntity, pos, state);
        this.defaultVariant = defaultVariant;
        this.totalSymbols = totalSymbols;
        this.symbolMap = this.newSymbolMap();
        this.generation = gen;
        this.network = defaultNetwork;
        this.verticalCenterHeight = verticalCenterHeight;
        this.horizontalCenterHeight = horizontalCenterHeight;
        this.symbolInfo = new SymbolInfo();
        this.dhdInfo = new DHDInfo(this);
        this.addressFilterInfo = new AddressFilterInfo();
    }

    public AbstractStargateEntity(BlockEntityType<?> blockEntity, ResourceLocation defaultVariant, BlockPos pos, BlockState state, int totalSymbols, StargateInfo.Gen gen, int defaultNetwork) {
        this(blockEntity, defaultVariant, pos, state, totalSymbols, gen, defaultNetwork, 0.5f, 0.28125f);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
        this.updateClientState();
        this.dhdInfo.loadDHD();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.getByte("generation_step"));
        } else if (tag.contains("add_to_network")) {
            this.generationStep = StructureGenEntity.Step.SETUP;
        }
        this.connectionState = StargateConnection.State.fromByte(tag.getByte(CONNECTION_STATE));
        if (tag.contains(CONNECTION_ID, 8)) {
            try {
                this.connectionID = UUID.fromString(tag.getString(CONNECTION_ID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.deserializeStargateInfo(tag, registries, false);
    }

    public void deserializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgraded) {
        super.loadAdditional(tag, registries);
        this.timesOpened = tag.getInt(TIMES_OPENED);
        this.address.fromArray(tag.getIntArray(ADDRESS));
        this.network = tag.getInt(NETWORK);
        this.restrictNetwork = tag.getBoolean(RESTRICT_NETWORK);
        this.id9ChevronAddress = Address.Immutable.extendWithPointOfOrigin(new Address.Immutable(tag.getIntArray(ID_9_CHEVRON_ADDRESS)));
        if (tag.contains(DISPLAY_ID)) {
            this.displayID = tag.getBoolean(DISPLAY_ID);
        }
        if (isUpgraded) {
            this.upgraded = true;
        } else if (tag.contains(UPGRADED)) {
            this.upgraded = tag.getBoolean(UPGRADED);
        }
        if (tag.contains(LOCAL_POINT_OF_ORIGIN)) {
            this.localPointOfOrigin = tag.getBoolean(LOCAL_POINT_OF_ORIGIN);
        }
        if (tag.contains(PRIMARY)) {
            this.isPrimary = tag.getBoolean(PRIMARY);
        }
        if (tag.contains("protected")) {
            this.isProtected = tag.getBoolean("protected");
        }
        if (tag.contains(VARIANT)) {
            this.variant = ResourceLocation.tryParse((String)tag.getString(VARIANT));
        }
        if (tag.contains("dhd_pos")) {
            int[] pos = tag.getIntArray("dhd_pos");
            this.dhdInfo().setRelativePos(new Vec3i(pos[0], pos[1], pos[2]));
        }
        this.dhdInfo().setAutoclose(tag.getInt(AUTOCLOSE));
        this.addressFilterInfo().deserializeFilters(tag);
        this.blockCover.deserializeNBT(registries, tag.getCompound(COVER_BLOCKS));
        this.setChanged();
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.putByte("generation_step", this.generationStep.byteValue());
        }
        tag.putByte(CONNECTION_STATE, this.connectionState.byteValue());
        if (this.connectionID != null) {
            tag.putString(CONNECTION_ID, this.connectionID.toString());
        }
        this.serializeStargateInfo(tag, registries);
    }

    public CompoundTag serializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt(TIMES_OPENED, this.timesOpened);
        tag.putIntArray(ADDRESS, this.address.getArray());
        tag.putInt(NETWORK, this.network);
        tag.putBoolean(RESTRICT_NETWORK, this.restrictNetwork);
        tag.putIntArray(ID_9_CHEVRON_ADDRESS, this.id9ChevronAddress.toArray());
        tag.putLong(ENERGY, this.getEnergyStored());
        if (this.displayID) {
            tag.putBoolean(DISPLAY_ID, true);
        }
        if (this.upgraded) {
            tag.putBoolean(UPGRADED, true);
        }
        if (this.localPointOfOrigin) {
            tag.putBoolean(LOCAL_POINT_OF_ORIGIN, true);
        }
        if (this.isPrimary) {
            tag.putBoolean(PRIMARY, true);
        }
        if (this.isProtected) {
            tag.putBoolean("protected", true);
        }
        if (this.variant != null) {
            tag.putString(VARIANT, this.variant.toString());
        }
        if (this.dhdInfo().relativePos() != null) {
            Vec3i pos = this.dhdInfo().relativePos();
            tag.putIntArray("dhd_pos", new int[]{pos.getX(), pos.getY(), pos.getZ()});
        }
        tag.putInt(AUTOCLOSE, this.dhdInfo().autoclose());
        this.addressFilterInfo().serializeFilters(tag);
        tag.put(COVER_BLOCKS, (Tag)this.blockCover.serializeNBT(registries));
        super.saveAdditional(tag, registries);
        return tag;
    }

    public void addStargateToNetwork() {
        if (this.id9ChevronAddress.getType() != Address.Type.ADDRESS_9_CHEVRON || BlockEntityList.get(this.level).containsStargate(this.id9ChevronAddress)) {
            this.set9ChevronAddress(this.generate9ChevronAddress());
        }
        StargateNetwork.get(this.level).addStargate(this);
        this.setChanged();
    }

    public void removeStargateFromNetwork() {
        StargateNetwork.get(this.level).removeStargate(this.id9ChevronAddress);
    }

    public void set9ChevronAddress(Address.Immutable address) {
        this.id9ChevronAddress = address;
        this.setChanged();
        StargateJourney.LOGGER.info("Set 9-Chevron Address to " + String.valueOf(this.id9ChevronAddress));
    }

    public Address.Immutable get9ChevronAddress() {
        return this.id9ChevronAddress;
    }

    protected Address.Immutable generate9ChevronAddress() {
        Address.Immutable address;
        Random random = new Random();
        do {
            address = Address.Immutable.randomAddress(8, 36, random.nextLong());
        } while (BlockEntityList.get(this.level).containsStargate(address));
        return address;
    }

    private int[] newSymbolMap() {
        int[] symbolMap = new int[this.totalSymbols];
        for (int i = 0; i < this.totalSymbols; ++i) {
            symbolMap[i] = i;
        }
        return symbolMap;
    }

    public boolean remapSymbol(int originalSymbol, int newSymbol) {
        if (this.isSymbolOutOfBounds(originalSymbol)) {
            return false;
        }
        if (newSymbol < 0 || newSymbol > 48) {
            return false;
        }
        this.symbolMap[originalSymbol] = newSymbol;
        return true;
    }

    public int getMappedSymbol(int symbol) {
        if (symbol < 0 || symbol >= this.symbolMap.length) {
            return -1;
        }
        return this.symbolMap[symbol];
    }

    public int totalSymbols() {
        return this.totalSymbols;
    }

    public int getSymbolBounds() {
        return this.totalSymbols - 1;
    }

    public boolean isSymbolOutOfBounds(int symbol) {
        if (symbol < 0) {
            return true;
        }
        return symbol > this.getSymbolBounds();
    }

    public static int getChevron(AbstractStargateEntity stargate, int chevronNumber) {
        if (--chevronNumber < 0 || chevronNumber >= 8) {
            return 0;
        }
        return stargate.getEngagedChevrons()[chevronNumber];
    }

    public StargateInfo.Feedback dhdEngageSymbol(int symbol) {
        return this.engageSymbol(symbol);
    }

    public StargateInfo.Feedback engageSymbol(int symbol) {
        if (this.level.isClientSide()) {
            return StargateInfo.Feedback.NONE;
        }
        if (this.isSymbolOutOfBounds(symbol)) {
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_OUT_OF_BOUNDS);
        }
        return this.encodeSymbol(this.getMappedSymbol(symbol));
    }

    public StargateInfo.Feedback encodeSymbol(int symbol) {
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (symbol == 0) {
            return this.setRecentFeedback(this.lockPrimaryChevron());
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false, false));
    }

    public StargateInfo.Feedback encodeChevron(int symbol, boolean incoming, boolean encodeSound) {
        if (this.address.containsSymbol(symbol)) {
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (!this.address.canGrow()) {
            return this.resetStargate(StargateInfo.Feedback.INVALID_ADDRESS);
        }
        this.growAddress(symbol);
        this.chevronSound((short)this.getAddress().getLength(), incoming, false, encodeSound);
        if (!incoming) {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        } else {
            this.updateBasicInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
            this.updateCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming);
        }
        this.updateAdvancedCrystalInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.address.getLength(), AbstractStargateEntity.getChevron(this, this.address.getLength()), incoming, symbol);
        this.setChanged();
        return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_ENCODED);
    }

    protected StargateInfo.Feedback lockPrimaryChevron() {
        if (this.level.isClientSide()) {
            return StargateInfo.Feedback.NONE;
        }
        this.growAddress(0);
        if (!this.address.canBeDialed()) {
            this.chevronSound((short)0, false, false, false);
            return this.resetStargate(StargateInfo.Feedback.INCOMPLETE_ADDRESS);
        }
        if (!this.isConnected()) {
            if (!this.isObstructed()) {
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.getAddress().getLength(), 0, false, 0);
                StargateInfo.Feedback feedback = this.setRecentFeedback(this.engageStargate(this.getAddress(), true));
                this.chevronSound((short)0, false, false, false);
                return feedback;
            }
            return this.resetStargate(StargateInfo.Feedback.SELF_OBSTRUCTED, false);
        }
        return this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
    }

    public void chevronSound(short chevron, boolean incoming, boolean open, boolean encode) {
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.Chevron(this.worldPosition, chevron, incoming, open, encode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void openWormholeSound(boolean incoming) {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.OpenWormhole(this.worldPosition, incoming), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void idleWormholeSound(boolean incoming) {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.IdleWormhole(this.worldPosition, incoming), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void closeWormholeSound(boolean incoming) {
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.CloseWormhole(this.worldPosition, incoming), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public abstract void playRotationSound();

    public abstract void stopRotationSound();

    public void playWormholeIdleSound() {
        this.wormholeIdleSound.playSound();
    }

    public StargateInfo.Feedback engageStargate(Address address, boolean doKawoosh) {
        Stargate stargate;
        if (this.addressFilterInfo().getFilterType().shouldFilter()) {
            if (this.addressFilterInfo().getFilterType().isBlacklist() && this.addressFilterInfo().isAddressBlacklisted(address)) {
                return this.resetStargate(StargateInfo.Feedback.TARGET_BLACKLISTED);
            }
            if (this.addressFilterInfo().getFilterType().isWhitelist() && !this.addressFilterInfo().isAddressWhitelisted(address)) {
                return this.resetStargate(StargateInfo.Feedback.TARGET_NOT_WHITELISTED);
            }
        }
        if ((stargate = StargateNetwork.get(this.level).getStargate(this.get9ChevronAddress())) != null) {
            return Dialing.dialStargate(((ServerLevel)this.level).getServer(), stargate, address, doKawoosh);
        }
        StargateJourney.LOGGER.error("Stargate " + String.valueOf(this.get9ChevronAddress()) + " can't be found in the Stargate Network");
        return this.resetStargate(StargateInfo.Feedback.UNKNOWN_ERROR);
    }

    public void connectStargate(UUID connectionID, StargateConnection.State connectionState) {
        this.connectionID = connectionID;
        this.setConnected(connectionState);
        ++this.timesOpened;
        this.animationTick = 0;
        this.setChanged();
        this.updateStargate(false);
    }

    public static double kawooshFunction(int kawooshTime) {
        return 8.0 * Math.sin(Math.PI * (double)kawooshTime / 40.0);
    }

    public void doKawoosh() {
        int kawooshTime = this.getKawooshTickCount();
        if (kawooshTime > 40) {
            return;
        }
        Direction axisDirection = this.getDirection().getAxis() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        Direction direction = Orientation.getForwardDirection(this.getDirection(), this.getOrientation());
        double frontMultiplier = AbstractStargateEntity.kawooshFunction(kawooshTime);
        if (((Boolean)CommonStargateConfig.kawoosh_destroys_blocks.get()).booleanValue()) {
            this.destroyBlocks(frontMultiplier, axisDirection, direction);
        }
        if (((Boolean)CommonStargateConfig.kawoosh_disintegrates_entities.get()).booleanValue()) {
            this.disintegrateEntities(frontMultiplier, axisDirection, direction);
        }
    }

    protected void destroyBlocks(double frontMultiplier, Direction axisDirection, Direction direction) {
        BlockPos centerPos = this.getCenterPos();
        for (int width = -1; width <= 1; ++width) {
            for (int height = -1; height <= 1; ++height) {
                BlockPos pos = centerPos.relative(axisDirection, width).relative(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.level.getBlockState(pos);
                if (state.getBlock() instanceof AbstractStargateBlock) continue;
                for (int i = 0; i < (int)Math.round(frontMultiplier); ++i) {
                    BlockState relativeState;
                    BlockPos relativePos = pos.relative(direction, i);
                    if (this.level.getBlockState(relativePos).is(Blocks.AIR) || (relativeState = this.level.getBlockState(relativePos)).is(TagInit.Blocks.KAWOOSH_IMMUNE)) continue;
                    this.level.destroyBlock(relativePos, false);
                }
            }
        }
    }

    protected void disintegrateEntities(double frontMultiplier, Direction axisDirection, Direction direction) {
        Vec3 centerVector = this.getCenter();
        Vec3 backVector = centerVector.relative(axisDirection, -2.25).relative(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), -2.25);
        frontMultiplier = frontMultiplier > 7.0 ? 7.0 : frontMultiplier;
        Vec3 facingVector = Orientation.getForwardVector(direction, this.getOrientation());
        facingVector = facingVector.multiply(frontMultiplier, frontMultiplier, frontMultiplier);
        facingVector = facingVector.add(centerVector);
        facingVector = facingVector.relative(axisDirection, 2.25).relative(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), 2.25);
        AABB kawooshHitbox = new AABB(backVector.x(), backVector.y(), backVector.z(), facingVector.x(), facingVector.y(), facingVector.z());
        this.level.getEntitiesOfClass(Entity.class, kawooshHitbox).stream().forEach(entity -> {
            if (this.shouldDisintegrate((Entity)entity) && entity.isAlive()) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.awardStat((ResourceLocation)StatisticsInit.TIMES_KILLED_BY_KAWOOSH.get());
                }
                entity.hurt(DamageSourceInit.damageSource(this.level.getServer(), DamageSourceInit.KAWOOSH), Float.MAX_VALUE);
                entity.kill();
            }
        });
    }

    public boolean shouldDisintegrate(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return false;
        }
        if (!((Boolean)CommonStargateConfig.kawoosh_disintegrates_items.get()).booleanValue() && entity instanceof ItemEntity) {
            return false;
        }
        return !entity.getType().is(TagInit.Entities.KAWOOSH_IMMUNE);
    }

    public StargateInfo.Feedback resetStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.level.isClientSide()) {
            return StargateInfo.Feedback.NONE;
        }
        if (this.isConnected()) {
            this.closeWormholeSound(!this.isDialingOut());
            this.setConnected(StargateConnection.State.IDLE);
        }
        this.resetAddress(updateInterfaces);
        this.connectionID = null;
        this.setKawooshTickCount(0);
        this.setOpenTime(0);
        this.setTimeSinceLastTraveler(0);
        this.setTickCount(0);
        if (feedback.playFailSound() && !this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientBoundSoundPackets.Fail(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (updateInterfaces) {
            this.updateBasicInterfaceBlocks(EVENT_RESET, feedback.getCode());
            this.updateCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
            this.updateAdvancedCrystalInterfaceBlocks(EVENT_RESET, feedback.getCode(), feedback.getMessage());
        }
        this.dhdInfo().revalidateDHD();
        this.setChanged();
        if (feedback == StargateInfo.Feedback.UNKNOWN_ERROR) {
            StargateJourney.LOGGER.error("Reset Stargate at " + this.getBlockPos().getX() + " " + this.getBlockPos().getY() + " " + this.getBlockPos().getZ() + " " + this.getLevel().dimension().location().toString() + " " + feedback.getMessage());
        } else {
            StargateJourney.LOGGER.debug("Reset Stargate at " + this.getBlockPos().getX() + " " + this.getBlockPos().getY() + " " + this.getBlockPos().getZ() + " " + this.getLevel().dimension().location().toString() + " " + feedback.getMessage());
        }
        return this.setRecentFeedback(feedback);
    }

    public StargateInfo.Feedback resetStargate(StargateInfo.Feedback feedback) {
        return this.resetStargate(feedback, true);
    }

    public StargateInfo.Feedback disconnectStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.isConnected()) {
            if (!((Boolean)CommonStargateConfig.end_connection_from_both_ends.get()).booleanValue() && !this.isDialingOut()) {
                return this.setRecentFeedback(StargateInfo.Feedback.WRONG_DISCONNECT_SIDE);
            }
            if (this.getOpenTime() <= 0) {
                return this.setRecentFeedback(StargateInfo.Feedback.CONNECTION_FORMING);
            }
        }
        return this.bypassDisconnectStargate(feedback, updateInterfaces);
    }

    public StargateInfo.Feedback bypassDisconnectStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.connectionID != null) {
            StargateNetwork.get(this.level).terminateConnection(this.connectionID, feedback);
        }
        return this.resetStargate(feedback, updateInterfaces);
    }

    public void updateStargate(boolean updateInterfaces) {
        this.updateStargate(this.level, updateInterfaces);
    }

    public void updateStargate(Level level, boolean updateInterfaces) {
        if (level.isClientSide()) {
            return;
        }
        StargateNetwork.get(level).updateStargate((ServerLevel)level, this);
        this.setStargateState(updateInterfaces);
    }

    protected void growAddress(int symbol) {
        this.address.addSymbol(symbol);
        this.setStargateState(true);
    }

    protected void resetAddress(boolean updateInterfaces) {
        this.address.reset();
        this.engagedChevrons = Dialing.DEFAULT_CHEVRON_CONFIGURATION;
        this.symbolMap = this.newSymbolMap();
        this.setConnectionState(StargateConnection.State.IDLE);
        this.setStargateState(updateInterfaces);
    }

    @Override
    public SymbolInfo symbolInfo() {
        return this.symbolInfo;
    }

    @Override
    public DHDInfo dhdInfo() {
        return this.dhdInfo;
    }

    @Override
    public AddressFilterInfo addressFilterInfo() {
        return this.addressFilterInfo;
    }

    public StargateInfo.Feedback setRecentFeedback(StargateInfo.Feedback feedback) {
        if (feedback != StargateInfo.Feedback.NONE) {
            this.recentFeedback = feedback;
        }
        this.dhdInfo().sendDHDFeedback(feedback);
        this.dhdInfo().updateDHD();
        return feedback;
    }

    public StargateInfo.Feedback getRecentFeedback() {
        return this.recentFeedback;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int network) {
        this.network = network;
        this.updateStargate(false);
    }

    public boolean getRestrictNetwork() {
        return this.restrictNetwork;
    }

    public void setRestrictNetwork(boolean restrictNetwork) {
        this.restrictNetwork = restrictNetwork;
    }

    public boolean isRestricted(int network) {
        if (this.getRestrictNetwork()) {
            return network != this.getNetwork();
        }
        return false;
    }

    public StargateInfo.Gen getGeneration() {
        return this.generation;
    }

    public void setKawooshTickCount(int kawooshTick) {
        this.kawooshTick = kawooshTick;
    }

    public int getKawooshTickCount() {
        return this.kawooshTick;
    }

    public void setTickCount(int animationTick) {
        this.animationTick = animationTick;
    }

    public int getTickCount() {
        return this.animationTick;
    }

    public int increaseTickCount() {
        ++this.animationTick;
        return this.animationTick;
    }

    public void setOpenTime(int openTime) {
        this.openTime = openTime < 0 ? 0 : openTime;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public boolean isWormholeOpen() {
        return this.getOpenTime() > 0;
    }

    public void setTimeSinceLastTraveler(int timeSinceLastTraveler) {
        this.timeSinceLastTraveler = timeSinceLastTraveler < 0 ? 0 : timeSinceLastTraveler;
    }

    public int getTimeSinceLastTraveler() {
        return this.timeSinceLastTraveler;
    }

    public int getTimesOpened() {
        return this.timesOpened;
    }

    public void setVariant(ResourceLocation variant) {
        this.variant = variant;
    }

    public ResourceLocation getVariant() {
        return this.variant;
    }

    public ResourceLocation defaultVariant() {
        return this.defaultVariant;
    }

    public void setAddress(Address address) {
        this.address = new Address.Mutable(address);
        this.setChanged();
    }

    public Address.Mutable getAddress() {
        return this.address;
    }

    public int getChevronsEngaged() {
        return this.address.getLength();
    }

    public void setEngagedChevrons(int[] engagedChevrons) {
        this.engagedChevrons = engagedChevrons;
    }

    public int[] getEngagedChevrons() {
        return this.engagedChevrons;
    }

    public int chevronsRendered() {
        return this.address.regularSymbolCount();
    }

    public int getRedstoneSymbolOutput() {
        return 0;
    }

    public int getRedstoneSegmentOutput() {
        return 0;
    }

    public BlockPos getCenterPos() {
        if (this.centerPosition == null) {
            BlockPos mainBlockPos = this.getBlockPos();
            Direction centerDirection = Orientation.getCenterDirection(this.getDirection(), this.getOrientation());
            this.centerPosition = mainBlockPos.relative(centerDirection, 3);
        }
        return this.centerPosition;
    }

    public Vec3 getCenter() {
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)centerPos.getX() + 0.5, (double)centerPos.getY() + y, (double)centerPos.getZ() + 0.5);
    }

    public Vec3 getRelativeCenter() {
        BlockPos mainBlockPos = this.getBlockPos();
        BlockPos centerPos = this.getCenterPos();
        double y = this.getVerticalCenterHeight();
        Orientation orientation = this.getOrientation();
        if (orientation != null && orientation != Orientation.REGULAR) {
            y = this.getHorizontalCenterHeight();
        }
        return new Vec3((double)(centerPos.getX() - mainBlockPos.getX()) + 0.5, (double)(centerPos.getY() - mainBlockPos.getY()) + y, (double)(centerPos.getZ() - mainBlockPos.getZ()) + 0.5);
    }

    protected BlockState getState() {
        BlockPos gatePos = this.getBlockPos();
        return this.level.getBlockState(gatePos);
    }

    public Orientation getOrientation() {
        if (this.orientation == null) {
            BlockState gateState = this.getState();
            if (gateState.getBlock() instanceof AbstractStargateBaseBlock) {
                this.orientation = (Orientation)((Object)gateState.getValue((Property)AbstractStargateBaseBlock.ORIENTATION));
            } else {
                StargateJourney.LOGGER.error("AbstractStargateEntity.getOrientation expected AbstractStargateBaseBlock at {} but found {} instead", (Object)this.getBlockPos(), (Object)gateState);
            }
        }
        return this.orientation;
    }

    public Direction getDirection() {
        if (this.direction == null) {
            BlockState gateState = this.getState();
            if (gateState.getBlock() instanceof AbstractStargateBaseBlock) {
                this.direction = (Direction)gateState.getValue((Property)AbstractStargateBaseBlock.FACING);
            } else {
                StargateJourney.LOGGER.error("AbstractStargateEntity.getDirection expected AbstractStargateBaseBlock at {} but found {} instead", (Object)this.getBlockPos(), (Object)gateState);
            }
        }
        return this.direction;
    }

    public void setConnectionState(StargateConnection.State connectionState) {
        this.connectionState = connectionState;
    }

    public void setConnected(StargateConnection.State connectionState) {
        this.setConnectionState(connectionState);
        this.setStargateState(true);
        if (FORCE_LOAD_CHUNK) {
            if (connectionState != StargateConnection.State.IDLE) {
                this.level.getServer().getLevel(this.level.dimension()).setChunkForced(SectionPos.blockToSectionCoord((int)this.getBlockPos().getX()), SectionPos.blockToSectionCoord((int)this.getBlockPos().getZ()), true);
            } else {
                this.level.getServer().getLevel(this.level.dimension()).setChunkForced(SectionPos.blockToSectionCoord((int)this.getBlockPos().getX()), SectionPos.blockToSectionCoord((int)this.getBlockPos().getZ()), false);
            }
        }
    }

    public void setStargateState(boolean updateInterfaces) {
        this.setStargateState(updateInterfaces, false, ShieldingState.OPEN);
        this.updateClientState();
    }

    public void setStargateState(boolean updateInterfaces, boolean updateIris, ShieldingState shieldingState) {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.getState();
        Block block = gateState.getBlock();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargate = (AbstractStargateBaseBlock)block;
            stargate.updateStargate(this.level, gatePos, gateState, shieldingState);
            if (updateIris) {
                stargate.updateIris(this.level, gatePos, gateState, shieldingState);
            }
            if (updateInterfaces) {
                this.updateInterfaceBlocks(null, new Object[0]);
            }
        } else {
            StargateJourney.LOGGER.error("AbstractStargateEntity.setStargateState expected AbstractStargateBaseBlock at {} but found {} instead", (Object)gatePos, (Object)gateState);
        }
        this.setChanged();
    }

    public StargateConnection.State getConnectionState() {
        return this.connectionState;
    }

    public boolean isConnected() {
        return this.getConnectionState().isConnected();
    }

    public boolean isDialingOut() {
        return this.getConnectionState().isDialingOut();
    }

    protected int getMaxObstructiveBlocks() {
        return (Integer)CommonStargateConfig.max_obstructive_blocks.get();
    }

    public boolean isObstructed() {
        Direction direction = this.getDirection().getAxis() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST;
        BlockPos centerPos = this.getCenterPos();
        int obstructingBlocks = 0;
        for (int width = -2; width <= 2; ++width) {
            for (int height = -2; height <= 2; ++height) {
                BlockPos pos = centerPos.relative(direction, width).relative(Orientation.getCenterDirection(this.getDirection(), this.getOrientation()), height);
                BlockState state = this.level.getBlockState(pos);
                if ((state.canBeReplaced() || state.getBlock() instanceof AbstractStargateBlock || state.getBlock() instanceof AbstractShieldingBlock) && !state.getFluidState().is((Fluid)Fluids.LAVA)) continue;
                ++obstructingBlocks;
            }
        }
        return obstructingBlocks >= this.getMaxObstructiveBlocks();
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.getType(), (CompoundTag)this.serializeStargateInfo(tag, registries));
    }

    public void updateBasicInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.getState();
        Block block = gateState.getBlock();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.getValue((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.getValue(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.relative(direction);
                    BlockState state = this.level.getBlockState(pos);
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (!(blockEntity instanceof BasicInterfaceEntity)) continue;
                    BasicInterfaceEntity interfaceEntity = (BasicInterfaceEntity)blockEntity;
                    if (direction.getOpposite() != state.getValue((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.level.updateNeighborsAt(pos, this.level.getBlockState(pos).getBlock());
                    interfaceEntity.setChanged();
                }
            }
        }
    }

    public void updateCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.getState();
        Block block = gateState.getBlock();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.getValue((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.getValue(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.relative(direction);
                    BlockState state = this.level.getBlockState(pos);
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (!(blockEntity instanceof CrystalInterfaceEntity)) continue;
                    CrystalInterfaceEntity interfaceEntity = (CrystalInterfaceEntity)blockEntity;
                    if (direction.getOpposite() != state.getValue((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.level.updateNeighborsAt(pos, this.level.getBlockState(pos).getBlock());
                    interfaceEntity.setChanged();
                }
            }
        }
    }

    public void updateAdvancedCrystalInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.getState();
        Block block = gateState.getBlock();
        if (block instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            for (StargatePart part : stargateBlock.getParts()) {
                BlockPos ringPos = part.getRingPos(gatePos, (Direction)gateState.getValue((Property)AbstractStargateBlock.FACING), (Orientation)((Object)gateState.getValue(AbstractStargateBlock.ORIENTATION)));
                for (Direction direction : Direction.values()) {
                    BlockPos pos = ringPos.relative(direction);
                    BlockState state = this.level.getBlockState(pos);
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (!(blockEntity instanceof AdvancedCrystalInterfaceEntity)) continue;
                    AdvancedCrystalInterfaceEntity interfaceEntity = (AdvancedCrystalInterfaceEntity)blockEntity;
                    if (direction.getOpposite() != state.getValue((Property)AbstractInterfaceBlock.FACING)) continue;
                    if (eventName != null) {
                        interfaceEntity.queueEvent(eventName, objects);
                    }
                    this.level.updateNeighborsAt(pos, this.level.getBlockState(pos).getBlock());
                    interfaceEntity.setChanged();
                }
            }
        }
    }

    public void updateInterfaceBlocks(@Nullable String eventName, Object ... objects) {
        this.updateBasicInterfaceBlocks(eventName, objects);
        this.updateCrystalInterfaceBlocks(eventName, objects);
        this.updateAdvancedCrystalInterfaceBlocks(eventName, objects);
    }

    public void setOpenSoundLead(int openSoundLead) {
        this.openSoundLead = openSoundLead;
    }

    public int getOpenSoundLead() {
        return this.openSoundLead;
    }

    public abstract StargateInfo.ChevronLockSpeed getChevronLockSpeed(boolean var1);

    @Override
    public void getStatus(Player player) {
        if (this.level.isClientSide()) {
            return;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.point_of_origin").append((Component)Component.literal((String)(": " + String.valueOf(this.symbolInfo().pointOfOrigin())))).withStyle(ChatFormatting.DARK_PURPLE));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.symbols").append((Component)Component.literal((String)(": " + String.valueOf(this.symbolInfo().symbols())))).withStyle(ChatFormatting.LIGHT_PURPLE));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.times_opened").append((Component)Component.literal((String)(": " + this.timesOpened))).withStyle(ChatFormatting.BLUE));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.has_dhd").append((Component)Component.literal((String)(": " + this.dhdInfo().hasDHD()))).withStyle(ChatFormatting.GOLD));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.autoclose").append((Component)Component.literal((String)(": " + this.dhdInfo().autoclose()))).withStyle(ChatFormatting.RED));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.last_traveler_time").append((Component)Component.literal((String)(": " + this.getTimeSinceLastTraveler()))).withStyle(ChatFormatting.DARK_PURPLE));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.encoded_address").append((Component)Component.literal((String)": ").append(this.address.toComponent(true))).withStyle(ChatFormatting.GREEN));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.recent_feedback").append((Component)Component.literal((String)": ").append(this.getRecentFeedback().getFeedbackMessage())).withStyle(ChatFormatting.WHITE));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.9_chevron_address").append(": ").withStyle(ChatFormatting.AQUA).append(this.id9ChevronAddress.toComponent(true)));
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.add_to_network").append((Component)Component.literal((String)(": " + (this.generationStep == StructureGenEntity.Step.GENERATED)))).withStyle(ChatFormatting.YELLOW));
        if (this.isPrimary()) {
            player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.is_primary").withStyle(ChatFormatting.DARK_GREEN));
        }
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.open_time").append((Component)ComponentHelper.tickTimer(this.getOpenTime(), Stargate.getMaxGateOpenTime(), ChatFormatting.DARK_AQUA)));
        super.getStatus(player);
    }

    @Override
    protected boolean canReceiveZeroPointEnergy() {
        return (Boolean)CommonZPMConfig.stargates_use_zero_point_energy.get();
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return false;
    }

    @Override
    public long capacity() {
        return (Long)CommonStargateConfig.stargate_energy_capacity.get();
    }

    @Override
    public long maxReceive() {
        return (Long)CommonStargateConfig.stargate_energy_max_receive.get();
    }

    @Override
    public long maxExtract() {
        return (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    }

    public boolean pushTraveler() {
        if (this.getOrientation() == Orientation.UPWARD) {
            return true;
        }
        return CAVUM_TENEBRAE.equals((Object)this.getLevel().dimension().location());
    }

    public float getVerticalCenterHeight() {
        return this.verticalCenterHeight;
    }

    public float getHorizontalCenterHeight() {
        return this.horizontalCenterHeight;
    }

    public abstract void registerInterfaceMethods(StargatePeripheralWrapper var1);

    public void doWhileConnecting(boolean incoming, boolean doKawoosh, int kawooshStartTicks, int connectionTime) {
        if (!doKawoosh) {
            return;
        }
        if (connectionTime == kawooshStartTicks - this.getOpenSoundLead()) {
            this.openWormholeSound(incoming);
        }
        if (connectionTime >= kawooshStartTicks) {
            this.doKawoosh();
        }
    }

    public void doWhileDialed(Address dialingAddress, int kawooshStartTicks, boolean doKawoosh, int connectionTime) {
        if (connectionTime > kawooshStartTicks) {
            return;
        }
        StargateInfo.ChevronLockSpeed chevronLockSpeed = this.getChevronLockSpeed(doKawoosh);
        if (connectionTime % chevronLockSpeed.getChevronWaitTicks() == 0) {
            int dialedAddressLength = this.getAddress().getLength();
            int dialingAddressLength = dialingAddress.getLength();
            if (dialedAddressLength < dialingAddress.getLength()) {
                if (connectionTime / chevronLockSpeed.getChevronWaitTicks() == 4 && dialingAddressLength < 7) {
                    return;
                }
                if (connectionTime / chevronLockSpeed.getChevronWaitTicks() == 5 && dialingAddressLength < 8) {
                    return;
                }
                this.encodeChevron(dialingAddress.symbolAt(dialedAddressLength), true, false);
            } else {
                this.chevronSound((short)0, true, false, false);
                this.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.getAddress().getLength() + 1, AbstractStargateEntity.getChevron(this, this.getAddress().getLength() + 1), true, 0);
            }
        }
    }

    public void doWhileConnected(boolean incoming, int connectionTime) {
        this.idleWormholeSound(incoming);
    }

    public List<Entity> findWormholeCandidates() {
        Vec3 centerPos = this.getCenter();
        AABB localBox = new AABB(centerPos.x - 2.5, centerPos.y - 2.5, centerPos.z - 2.5, centerPos.x + 2.5, centerPos.y + 2.5, centerPos.z + 2.5);
        List wormholeCandidates = this.getLevel().getEntitiesOfClass(Entity.class, localBox, entity -> entity.isAlive() && !entity.getType().is(TagInit.Entities.WORMHOLE_IGNORES));
        return wormholeCandidates;
    }

    public boolean updateClient() {
        if (this.level.isClientSide()) {
            return false;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundStargateUpdatePacket(this.worldPosition, this.getEnergyStored(), this.openTime, this.timeSinceLastTraveler, this.address.getArray(), this.engagedChevrons, this.kawooshTick, this.animationTick, 0, this.symbolInfo().pointOfOrigin(), this.symbolInfo().symbols(), this.variant, ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public boolean updateClientState() {
        if (this.level.isClientSide()) {
            return false;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundStargateStateUpdatePacket(this.worldPosition, this.connectionState, this.blockCover.canSinkGate, this.blockCover.blockStates), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public void spawnCoverParticles() {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundStargateParticleSpawnPacket(this.worldPosition, this.blockCover.blockStates), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public UUID getConnectionID() {
        return this.connectionID;
    }

    public void checkStargate() {
        if (this.isConnected() && !StargateNetwork.get(this.getLevel()).hasConnection(this.getConnectionID())) {
            this.resetStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_NETWORK);
        }
    }

    public boolean sendStargateMessage(String message) {
        return StargateNetwork.get(this.level).sendStargateMessage(this, this.connectionID, message);
    }

    public void receiveStargateMessage(String message) {
        this.updateInterfaceBlocks(EVENT_MESSAGE_RECEIVED, message);
    }

    public float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_stargate_transmission_distance.get()).intValue();
    }

    @Override
    public void receiveTransmission(int transmissionJumps, int frequency, String transmission) {
        if (transmissionJumps < (Integer)CommonTransmissionConfig.max_transmission_jumps.get()) {
            StargateNetwork.get(this.level).sendStargateTransmission(this, this.connectionID, transmissionJumps + 1, frequency, transmission);
        }
    }

    public void forwardTransmission(int transmissionJumps, int frequency, String transmission) {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.level.getChunk(this.getBlockPos().east(16 * x).south(16 * z));
                Set positions = chunk.getBlockEntitiesPos();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        receiver.receiveTransmission(transmissionJumps, frequency, transmission);
                    }
                });
            }
        }
    }

    public float checkConnectionShieldingState() {
        return StargateNetwork.get(this.level).checkStargateShieldingState(this, this.connectionID);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractStargateEntity stargate) {
        if (stargate.isConnected()) {
            stargate.increaseTickCount();
        }
        if (level.isClientSide()) {
            return;
        }
        stargate.updateClient();
        if (!stargate.initialClientSync) {
            stargate.updateClientState();
        }
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    private void trySetPrimary() {
        SolarSystem.Serializable solarSystem = Universe.get(this.level).getSolarSystemFromDimension((ResourceKey<Level>)this.level.dimension());
        if (solarSystem == null || solarSystem.primaryAddress() != null) {
            return;
        }
        solarSystem.setPrimaryStargate(this.get9ChevronAddress());
    }

    public void generate() {
        this.addStargateToNetwork();
        this.generateAdditional(StructureGenEntity.Step.READY);
        if (this.isPrimary()) {
            this.trySetPrimary();
        }
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }

    public void generateAdditional(StructureGenEntity.Step generationStep) {
    }

    public void displayID() {
        this.displayID = true;
    }

    public void upgraded() {
        this.upgraded = true;
    }

    public void localPointOfOrigin() {
        this.localPointOfOrigin = true;
    }

    public void setPrimary() {
        this.isPrimary = true;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public boolean hasPermissions(Player player, boolean sendMessage) {
        if (this.isProtected() && !player.hasPermissions(CommonPermissionConfig.protected_stargate_permissions.get())) {
            if (sendMessage) {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.protected_permissions").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }
}

