/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.tech.AbstractCrystallizerBlock;
import net.povstalec.sgjourney.common.packets.ClientboundCrystallizerUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCrystallizerEntity
extends EnergyBlockEntity {
    private static final String PROGRESS = "progress";
    private static final String CRYSTAL_BASE_INVENTORY = "crystal_base_inventory";
    private static final String PRIMARY_INGREDIENT_INVENTORY = "primary_ingredient_inventory";
    private static final String SECONDARY_INGREDIENT_INVENTORY = "secondary_ingredient_inventory";
    private static final String OUTPUT_INVENTORY = "output_inventory";
    private static final String FLUID_INPUT_INVENTORY = "fluid_input_inventory";
    public static final int LIQUID_NAQUADAH_CAPACITY = 4000;
    public static final int MAX_PROGRESS = 200;
    protected final ItemStackHandler crystalBaseHandler = this.createCrystalBaseHandler();
    protected final Lazy<IItemHandler> lazyCrystalBaseHandler = Lazy.of(() -> this.crystalBaseHandler);
    protected final ItemStackHandler primaryIngredientHandler = this.createIngredientHandler();
    protected final Lazy<IItemHandler> lazyPrimaryIngredientHandler = Lazy.of(() -> this.primaryIngredientHandler);
    protected final ItemStackHandler secondaryIngredientHandler = this.createIngredientHandler();
    protected final Lazy<IItemHandler> lazySecondaryIngredientHandler = Lazy.of(() -> this.secondaryIngredientHandler);
    protected final ItemStackHandler outputHandler = this.createOutputHandler();
    protected final Lazy<IItemHandler> lazyOutputHandler = Lazy.of(() -> this.outputHandler);
    protected final ItemStackHandler fluidInputHandler = this.createFluidInputHandler();
    protected final Lazy<IItemHandler> lazyFluidInputHandler = Lazy.of(() -> this.fluidInputHandler);
    protected final FluidTank fluidTank = this.createFluidTank();
    protected Lazy<IFluidHandler> lazyFluidHandler = Lazy.of(() -> this.fluidTank);
    public int progress = 0;

    public AbstractCrystallizerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyCrystalBaseHandler.invalidate();
        this.lazyPrimaryIngredientHandler.invalidate();
        this.lazySecondaryIngredientHandler.invalidate();
        this.lazyOutputHandler.invalidate();
        this.lazyFluidInputHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.crystalBaseHandler.deserializeNBT(registries, nbt.getCompound(CRYSTAL_BASE_INVENTORY));
        this.primaryIngredientHandler.deserializeNBT(registries, nbt.getCompound(PRIMARY_INGREDIENT_INVENTORY));
        this.secondaryIngredientHandler.deserializeNBT(registries, nbt.getCompound(SECONDARY_INGREDIENT_INVENTORY));
        this.outputHandler.deserializeNBT(registries, nbt.getCompound(OUTPUT_INVENTORY));
        this.fluidInputHandler.deserializeNBT(registries, nbt.getCompound(FLUID_INPUT_INVENTORY));
        this.fluidTank.readFromNBT(registries, nbt);
        this.progress = nbt.getInt(PROGRESS);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put(CRYSTAL_BASE_INVENTORY, (Tag)this.crystalBaseHandler.serializeNBT(registries));
        nbt.put(PRIMARY_INGREDIENT_INVENTORY, (Tag)this.primaryIngredientHandler.serializeNBT(registries));
        nbt.put(SECONDARY_INGREDIENT_INVENTORY, (Tag)this.secondaryIngredientHandler.serializeNBT(registries));
        nbt.put(OUTPUT_INVENTORY, (Tag)this.outputHandler.serializeNBT(registries));
        nbt.put(FLUID_INPUT_INVENTORY, (Tag)this.fluidInputHandler.serializeNBT(registries));
        nbt = this.fluidTank.writeToNBT(registries, nbt);
        nbt.putInt(PROGRESS, this.progress);
        super.saveAdditional(nbt, registries);
    }

    public abstract Fluid getDesiredFluid();

    public IFluidHandler getFluidHandler(Direction side) {
        return (IFluidHandler)this.lazyFluidHandler.get();
    }

    public IItemHandler getItemHandler(Direction side) {
        if (side == Direction.UP) {
            return (IItemHandler)this.lazyCrystalBaseHandler.get();
        }
        if (side == Direction.DOWN) {
            return (IItemHandler)this.lazyOutputHandler.get();
        }
        if (side == this.getDirection().getClockWise()) {
            return (IItemHandler)this.lazyPrimaryIngredientHandler.get();
        }
        if (side == this.getDirection().getCounterClockWise()) {
            return (IItemHandler)this.lazySecondaryIngredientHandler.get();
        }
        return (IItemHandler)this.lazyFluidInputHandler.get();
    }

    private FluidTank createFluidTank() {
        return new FluidTank(4000){

            protected void onContentsChanged() {
                AbstractCrystallizerEntity.this.setChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid() == AbstractCrystallizerEntity.this.getDesiredFluid();
            }
        };
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidTank.setFluid(fluidStack);
    }

    public FluidStack getFluid() {
        return this.fluidTank.getFluid();
    }

    private ItemStackHandler createCrystalBaseHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private ItemStackHandler createIngredientHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private ItemStackHandler createOutputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            @NotNull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private ItemStackHandler createFluidInputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(Capabilities.FluidHandler.ITEM) != null;
            }

            @NotNull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nullable
    public Direction getDirection() {
        BlockPos gatePos = this.getBlockPos();
        BlockState gateState = this.level.getBlockState(gatePos);
        if (gateState.getBlock() instanceof AbstractCrystallizerBlock) {
            return (Direction)gateState.getValue((Property)AbstractCrystallizerBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean hasFluidItem() {
        return this.fluidInputHandler.getStackInSlot(0).getCount() > 0;
    }

    public void fillFluidTank(FluidStack stack, ItemStack container) {
        this.fluidTank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.fluidInputHandler.extractItem(0, 1, false);
        this.fluidInputHandler.insertItem(0, container, false);
    }

    public void drainFluidFromItem() {
        IFluidHandlerItem cap = (IFluidHandlerItem)this.fluidInputHandler.getStackInSlot(0).getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            int drainAmount = Math.min(this.fluidTank.getSpace(), 1000);
            FluidStack stack = cap.getFluidInTank(0);
            if (this.fluidTank.isFluidValid(stack)) {
                stack = cap.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillFluidTank(stack, cap.getContainer());
            }
        }
    }

    public Lazy<IItemHandler> getItemHandler(int slot) {
        return switch (slot) {
            case 1 -> this.lazyPrimaryIngredientHandler;
            case 2 -> this.lazySecondaryIngredientHandler;
            case 3 -> this.lazyOutputHandler;
            case 4 -> this.lazyFluidInputHandler;
            default -> this.lazyCrystalBaseHandler;
        };
    }

    @Override
    protected long capacity() {
        return 0L;
    }

    @Override
    protected long maxReceive() {
        return 0L;
    }

    @Override
    protected long maxExtract() {
        return 0L;
    }

    protected static boolean hasSpaceInOutputSlot(SimpleContainer inventory, ItemStack stack) {
        if (inventory.getItem(3).getMaxStackSize() <= inventory.getItem(3).getCount()) {
            return false;
        }
        return inventory.getItem(3).getItem() == stack.getItem() || inventory.getItem(3).isEmpty();
    }

    protected abstract boolean hasIngredients();

    protected abstract void crystallize();

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractCrystallizerEntity crystallizer) {
        if (level.isClientSide()) {
            return;
        }
        if (crystallizer.hasFluidItem()) {
            crystallizer.drainFluidFromItem();
        }
        if (crystallizer.hasIngredients() && crystallizer.fluidTank.getFluidAmount() > 0) {
            ++crystallizer.progress;
            crystallizer.fluidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
            AbstractCrystallizerEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (crystallizer.progress >= 200) {
                crystallizer.crystallize();
            }
        } else {
            crystallizer.progress = 0;
            AbstractCrystallizerEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(crystallizer.worldPosition).getPos(), (CustomPacketPayload)new ClientboundCrystallizerUpdatePacket(crystallizer.worldPosition, crystallizer.getFluid(), crystallizer.progress), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

