/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.tech.TransceiverBlock;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.TransceiverPeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.packets.ClientboundTransceiverUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.ITransmissionReceiver;
import org.jetbrains.annotations.NotNull;

public class TransceiverEntity
extends BlockEntity
implements ITransmissionReceiver {
    public static final String IDC = "idc";
    public static final String FREQUENCY = "frequency";
    public static final String EDIT_FREQUENCY = "edit_frequency";
    private static final String EVENT_TRANSMISSION_RECEIVED = "transceiver_transmission_received";
    private static final short MAX_TRANSMISSION_TICKS = 20;
    private boolean editingFrequency = false;
    private int frequency = 0;
    private String idc = "";
    private short transmissionTicks = 0;
    protected TransceiverPeripheralWrapper peripheralWrapper;

    public TransceiverEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TRANSCEIVER.get(), pos, state);
        if (ModList.get().isLoaded("computercraft")) {
            this.peripheralWrapper = new TransceiverPeripheralWrapper(this);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.editingFrequency = tag.getBoolean(EDIT_FREQUENCY);
        this.frequency = tag.getInt(FREQUENCY);
        this.idc = tag.getString(IDC);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean(EDIT_FREQUENCY, this.editingFrequency);
        tag.putInt(FREQUENCY, this.frequency);
        tag.putString(IDC, this.idc);
    }

    public float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_transceiver_transmission_distance.get()).intValue();
    }

    public float transmissionRadius2() {
        return this.transmissionRadius() * this.transmissionRadius();
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
        this.setChanged();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setEditingFrequency(boolean editingFrequency) {
        this.editingFrequency = editingFrequency;
    }

    public boolean editingFrequency() {
        return this.editingFrequency;
    }

    public void setCurrentCode(String idc) {
        this.idc = idc;
        this.setChanged();
    }

    public String getCurrentCode() {
        return this.idc;
    }

    public void toggleFrequency() {
        this.editingFrequency = !this.editingFrequency;
        this.setChanged();
    }

    @Override
    public void receiveTransmission(int transmissionJumps, int frequency, String transmission) {
        if (this.level.isClientSide() || frequency != this.getFrequency()) {
            return;
        }
        boolean codeIsCorrect = this.getCurrentCode().equals(transmission);
        this.queueEvent(EVENT_TRANSMISSION_RECEIVED, frequency, transmission, codeIsCorrect);
        Level level = this.getLevel();
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof TransceiverBlock) {
            TransceiverBlock transceiver = (TransceiverBlock)block;
            transceiver.receiveTransmission(state, level, pos, codeIsCorrect);
        }
    }

    public void sendTransmission() {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.level.getChunk(this.getBlockPos().east(16 * x).south(16 * z));
                Set positions = chunk.getBlockEntitiesPos();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        if (blockEntity != this) {
                            receiver.receiveTransmission(0, this.getFrequency(), this.getCurrentCode());
                        }
                    }
                });
            }
        }
        Level level = this.getLevel();
        BlockPos pos2 = this.getBlockPos();
        BlockState state = this.getBlockState();
        level.setBlock(pos2, (BlockState)state.setValue((Property)TransceiverBlock.TRANSMITTING, (Comparable)Boolean.valueOf(true)), 2);
        this.transmissionTicks = (short)20;
    }

    public int checkShieldingState() {
        int roundedRadius = (int)Math.ceil(this.transmissionRadius() / 16.0f);
        ArrayList stargates = new ArrayList();
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = this.level.getChunk(this.getBlockPos().east(16 * x).south(16 * z));
                Set positions = chunk.getBlockEntitiesPos();
                positions.stream().forEach(pos -> {
                    BlockEntity patt0$temp = this.level.getBlockEntity(pos);
                    if (patt0$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt0$temp;
                        if (TransceiverEntity.distance2(this.getBlockPos(), stargate.getBlockPos()) <= (double)this.transmissionRadius2()) {
                            stargates.add(stargate);
                        }
                    }
                });
            }
        }
        if (stargates.size() == 0) {
            return -1;
        }
        stargates.sort((stargateA, stargateB) -> Double.valueOf(TransceiverEntity.distance2(this.getBlockPos(), stargateA.getBlockPos())).compareTo(TransceiverEntity.distance2(this.getBlockPos(), stargateB.getBlockPos())));
        AbstractStargateEntity stargate = (AbstractStargateEntity)stargates.get(0);
        if (!stargate.isConnected()) {
            return -2;
        }
        return Math.round(stargate.checkConnectionShieldingState());
    }

    public void addToCode(int number) {
        if (!this.editingFrequency) {
            if (this.idc.length() >= 16) {
                return;
            }
            this.idc = this.idc + String.valueOf(number);
        } else {
            long tempFrequency = this.frequency;
            if ((tempFrequency = tempFrequency * 10L + (long)number) > Integer.MAX_VALUE) {
                return;
            }
            this.frequency = (int)tempFrequency;
        }
        this.setChanged();
    }

    public void removeFromCode() {
        if (!this.editingFrequency) {
            if (this.idc.length() <= 0) {
                return;
            }
            this.idc = this.idc.substring(0, this.idc.length() - 1);
        } else {
            if (this.frequency <= 0) {
                return;
            }
            this.frequency /= 10;
        }
        this.setChanged();
    }

    public void updateClient() {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundTransceiverUpdatePacket(this.worldPosition, this.editingFrequency, this.idc, this.frequency), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static double distance2(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.getX() - pos.getX());
        int y = Math.abs(targetPos.getY() - pos.getY());
        int z = Math.abs(targetPos.getZ() - pos.getZ());
        return x * x + y * y + z * z;
    }

    public TransceiverPeripheralWrapper getPeripheralWrapper() {
        if (!ModList.get().isLoaded("computercraft")) {
            return null;
        }
        return this.peripheralWrapper;
    }

    public void queueEvent(String eventName, Object ... objects) {
        if (!ModList.get().isLoaded("computercraft")) {
            return;
        }
        if (this.peripheralWrapper != null) {
            this.peripheralWrapper.queueEvent(eventName, objects);
        }
    }

    private void handleTransmissionTicks() {
        if (this.transmissionTicks > 0) {
            this.transmissionTicks = (short)(this.transmissionTicks - 1);
            if (this.transmissionTicks == 0) {
                Level level = this.getLevel();
                BlockPos pos = this.getBlockPos();
                BlockState state = this.getBlockState();
                Block block = state.getBlock();
                if (block instanceof TransceiverBlock) {
                    TransceiverBlock transceiver = (TransceiverBlock)block;
                    transceiver.stopTransmitting(state, level, pos);
                }
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TransceiverEntity transceiver) {
        transceiver.handleTransmissionTicks();
        transceiver.updateClient();
    }
}

