/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.capabilities.ZeroPointEnergy;
import net.povstalec.sgjourney.common.config.CommonPermissionConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.NotNull;

public class ZPMHubEntity
extends EnergyBlockEntity
implements ProtectedBlockEntity {
    public static final String INVENTORY = "inventory";
    private static final long maxTransfer = (Long)CommonZPMConfig.zpm_hub_max_transfer.get();
    private static final long maxEnergyDisplayed = (Long)CommonZPMConfig.zpm_energy_per_level_of_entropy.get();
    private final ItemStackHandler itemHandler = this.createHandler();
    private final Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);
    protected boolean isProtected = false;

    public ZPMHubEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.ZPM_HUB.get(), pos, state);
    }

    @Override
    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.itemHandler.deserializeNBT(registries, nbt.getCompound(INVENTORY));
        if (nbt.contains("protected", 1)) {
            this.isProtected = nbt.getBoolean("protected");
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put(INVENTORY, (Tag)this.itemHandler.serializeNBT(registries));
        if (this.isProtected) {
            nbt.putBoolean("protected", true);
        }
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.lazyItemHandler.get();
    }

    @Nullable
    public IItemHandler getItemHandler(Direction side) {
        if (!this.isProtected() || CommonPermissionConfig.protected_inventory_access.get()) {
            return (IItemHandler)this.lazyItemHandler.get();
        }
        return null;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ZPMHubEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.getItem() == ItemInit.ZPM.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return side == Direction.DOWN;
    }

    @Override
    protected boolean receivesEnergy() {
        return false;
    }

    @Override
    public long capacity() {
        return maxEnergyDisplayed;
    }

    @Override
    public long maxReceive() {
        return 0L;
    }

    @Override
    public long maxExtract() {
        return maxTransfer;
    }

    @Override
    public void outputEnergy(Direction outputDirection) {
        IEnergyStorage itemEnergy;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.is((Item)ItemInit.ZPM.get()) && (itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && itemEnergy instanceof ZeroPointEnergy) {
            ZeroPointEnergy zpmEnergy = (ZeroPointEnergy)itemEnergy;
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(outputDirection));
            if (blockEntity == null) {
                return;
            }
            IEnergyStorage otherEnergy = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos().relative(outputDirection), (Object)outputDirection.getOpposite());
            if (otherEnergy != null) {
                if (otherEnergy instanceof SGJourneyEnergy) {
                    SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)otherEnergy;
                    long simulatedOutputAmount = zpmEnergy.extractLongEnergy(this.maxExtract(), true);
                    long simulatedReceiveAmount = sgjourneyEnergy.receiveZeroPointEnergy(simulatedOutputAmount, true);
                    zpmEnergy.extractLongEnergy(simulatedReceiveAmount, false);
                    sgjourneyEnergy.receiveZeroPointEnergy(simulatedReceiveAmount, false);
                } else if (((Boolean)CommonZPMConfig.other_mods_use_zero_point_energy.get()).booleanValue()) {
                    int simulatedOutputAmount = zpmEnergy.extractEnergy(SGJourneyEnergy.regularEnergy(this.maxExtract()), true);
                    int simulatedReceiveAmount = otherEnergy.receiveEnergy(simulatedOutputAmount, true);
                    zpmEnergy.extractLongEnergy(simulatedReceiveAmount, false);
                    otherEnergy.receiveEnergy(simulatedReceiveAmount, false);
                }
            }
        }
    }

    @Override
    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public boolean hasPermissions(Player player, boolean sendMessage) {
        if (this.isProtected() && !player.hasPermissions(CommonPermissionConfig.protected_zpm_hub_permissions.get())) {
            if (sendMessage) {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.protected_permissions").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ZPMHubEntity hub) {
        if (level.isClientSide()) {
            return;
        }
        hub.outputEnergy(Direction.DOWN);
    }
}

