/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.transporter;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.blocks.transporter.TransportRingsBlock;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.packets.ClientboundRingsUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class TransportRingsEntity
extends AbstractTransporterEntity {
    public static final int MAX_TRANSPORT_HEIGHT = 16;
    @Nullable
    private BlockPos transportPos = null;
    public int emptySpace = 0;
    public int transportHeight = 0;
    public int progress = -1;
    public int progressOld = -1;

    public TransportRingsEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get(), pos, state);
    }

    @Override
    public int getTimeOffset() {
        return this.getTransportHeight();
    }

    @Override
    @Nullable
    public List<Entity> entitiesToTransport() {
        AABB localBox = new AABB((double)(this.transportPos.getX() - 1), (double)this.transportPos.getY(), (double)(this.transportPos.getZ() - 1), (double)(this.transportPos.getX() + 2), (double)(this.transportPos.getY() + 3), (double)(this.transportPos.getZ() + 2));
        return this.level.getEntitiesOfClass(Entity.class, localBox);
    }

    @Override
    public BlockPos transportPos() {
        if (this.transportPos == null) {
            this.emptySpace = this.getEmptySpace();
            this.transportPos = new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + this.emptySpace, this.getBlockPos().getZ());
        }
        return this.transportPos;
    }

    public void updateClient() {
        if (!this.level.isClientSide()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundRingsUpdatePacket(this.getBlockPos(), this.emptySpace, this.transportHeight, this.progress), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void startTransport(Transporter target) {
        Transporter transporter = this.getTransporter();
        if (transporter == null) {
            return;
        }
        TransporterNetwork.get(this.level).createConnection(this.level.getServer(), transporter, target);
    }

    @Override
    public boolean connectTransporter(UUID connectionID) {
        this.transportPos();
        return super.connectTransporter(connectionID);
    }

    @Override
    public void resetTransporter() {
        this.emptySpace = 0;
        this.transportHeight = 0;
        this.transportPos = null;
        super.resetTransporter();
    }

    public int getTransportHeight() {
        if (this.transportHeight == 0) {
            int emptySpace = this.getEmptySpace();
            this.transportHeight = emptySpace > 0 ? Math.abs(emptySpace * 4) + 8 : Math.abs(emptySpace * 4);
        }
        return this.transportHeight;
    }

    @Override
    public void updateTicks(int connectionTime) {
        this.progress = connectionTime;
        this.progressOld = connectionTime;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TransportRingsEntity rings) {
        if (rings.isConnected()) {
            rings.doClientProgress();
        } else {
            rings.progress = -1;
            rings.progressOld = -1;
        }
        rings.updateClient();
    }

    private void doClientProgress() {
        if (!this.level.isClientSide() || this.progress < 0) {
            return;
        }
        this.progressOld = this.progress++;
    }

    public void updateProgress(int progress) {
        if (this.progress == -1 || progress == -1) {
            this.progress = progress;
            this.progressOld = progress;
        }
    }

    public void setProgress(int progress) {
        this.progressOld = this.progress;
        this.progress = progress;
    }

    public float getProgress(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.progress : Mth.lerp((float)partialTick, (float)this.progressOld, (float)this.progress);
    }

    @Override
    public boolean isConnected() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.level.getBlockState(pos);
        if (state.is((Block)BlockInit.TRANSPORT_RINGS.get())) {
            return (Boolean)this.level.getBlockState(pos).getValue((Property)TransportRingsBlock.ACTIVATED);
        }
        return false;
    }

    @Override
    public void setConnected(boolean connected) {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.level.getBlockState(pos);
        if (state.is((Block)BlockInit.TRANSPORT_RINGS.get())) {
            this.level.setBlock(pos, (BlockState)state.setValue((Property)TransportRingsBlock.ACTIVATED, (Comparable)Boolean.valueOf(connected)), 2);
        }
        this.loadChunk(connected);
    }

    private int getEmptySpace() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.level.getBlockState(pos);
        if (!state.is((Block)BlockInit.TRANSPORT_RINGS.get())) {
            return 0;
        }
        if (state.getValue((Property)TransportRingsBlock.FACING) == Direction.DOWN) {
            for (int i = 4; i <= 16; ++i) {
                if (this.level.getBlockState(pos.below(i)).canBeReplaced() || !this.level.getBlockState(pos.below(i - 1)).canBeReplaced() || !this.level.getBlockState(pos.below(i - 2)).canBeReplaced() || !this.level.getBlockState(pos.below(i - 3)).canBeReplaced()) continue;
                return -i + 1;
            }
        } else {
            for (int i = 1; i <= 16; ++i) {
                if (!this.level.getBlockState(pos.above(i)).canBeReplaced() || !this.level.getBlockState(pos.above(i + 1)).canBeReplaced() || !this.level.getBlockState(pos.above(i + 2)).canBeReplaced()) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public long capacity() {
        return 0L;
    }

    @Override
    public long maxReceive() {
        return 0L;
    }

    @Override
    public long maxExtract() {
        return 0L;
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.sgjourney.transport_rings");
    }
}

