/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldenIdolBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape ARTIFACT_HEAD = Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape ARTIFACT_BODY_1 = Block.box((double)6.0, (double)0.0, (double)7.0, (double)10.0, (double)12.0, (double)9.0);
    private static final VoxelShape ARTIFACT_BODY_2 = Block.box((double)7.0, (double)0.0, (double)6.0, (double)9.0, (double)12.0, (double)10.0);
    private static final VoxelShape RIGHT_HAND_1 = Block.box((double)4.0, (double)6.0, (double)7.0, (double)6.0, (double)12.0, (double)9.0);
    private static final VoxelShape LEFT_HAND_1 = Block.box((double)10.0, (double)6.0, (double)7.0, (double)12.0, (double)12.0, (double)9.0);
    private static final VoxelShape RIGHT_HAND_2 = Block.box((double)7.0, (double)6.0, (double)4.0, (double)9.0, (double)12.0, (double)6.0);
    private static final VoxelShape LEFT_HAND_2 = Block.box((double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)12.0, (double)12.0);
    private static final VoxelShape ARTIFACT_STRAIGHT = Shapes.or((VoxelShape)ARTIFACT_HEAD, (VoxelShape[])new VoxelShape[]{ARTIFACT_BODY_1, RIGHT_HAND_1, LEFT_HAND_1});
    private static final VoxelShape ARTIFACT_TURNED = Shapes.or((VoxelShape)ARTIFACT_HEAD, (VoxelShape[])new VoxelShape[]{ARTIFACT_BODY_2, RIGHT_HAND_2, LEFT_HAND_2});
    public static final MapCodec<GoldenIdolBlock> CODEC = GoldenIdolBlock.simpleCodec(GoldenIdolBlock::new);

    public GoldenIdolBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<GoldenIdolBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.X ? ARTIFACT_TURNED : ARTIFACT_STRAIGHT;
    }
}

