/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.dhd;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public abstract class AbstractDHDBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
ProtectedBlock {
    public AbstractDHDBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return;
        }
        if (oldState.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            dhd.unsetStargate();
        }
        super.onRemove(oldState, level, pos, newState, isMoving);
    }

    protected abstract void use(Level var1, BlockPos var2, Player var3, BlockHitResult var4);

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.use(level, pos, player, hitResult);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        this.use(level, pos, player, hitResult);
        return ItemInteractionResult.SUCCESS;
    }

    public abstract Block getDHD();

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof AbstractDHDEntity && !level.isClientSide() && !player.isCreative()) {
            ItemStack itemstack = new ItemStack((ItemLike)this.getDHD());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag blockEntityTag;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (blockEntityTag = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe()) != null && blockEntityTag.contains("generation_step", 1) && StructureGenEntity.Step.GENERATED != StructureGenEntity.Step.fromByte(blockEntityTag.getByte("generation_step"))) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.generates_inside_structure").withStyle(ChatFormatting.YELLOW));
        }
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.dhd.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("tooltip.sgjourney.dhd.dialing_menu"));
        tooltipComponents.add((Component)ComponentHelper.usage("tooltip.sgjourney.dhd.crystal_menu"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    @Nullable
    public ProtectedBlockEntity getProtectedBlockEntity(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            return dhd;
        }
        return null;
    }

    @Override
    public boolean hasPermissions(BlockGetter reader, BlockPos pos, BlockState state, Player player, boolean sendMessage) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            return dhd.hasPermissions(player, sendMessage);
        }
        return true;
    }
}

