/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.dhd;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.povstalec.sgjourney.common.block_entities.dhd.CrystalDHDEntity;
import net.povstalec.sgjourney.common.blocks.dhd.AbstractDHDBlock;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.menu.DHDCrystalMenu;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.misc.NetworkUtils;

public abstract class CrystalDHDBlock
extends AbstractDHDBlock {
    public CrystalDHDBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void openCrystalMenu(Player player, final CrystalDHDEntity dhd) {
        MenuProvider containerProvider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"screen.sgjourney.dhd");
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                return new DHDCrystalMenu(windowId, playerInventory, dhd);
            }
        };
        NetworkUtils.openMenu((ServerPlayer)player, containerProvider, dhd.getBlockPos());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag list1;
        CompoundTag blockEntityTag;
        ListTag tagList;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (tagList = (blockEntityTag = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe()).getCompound("crystal_inventory").getList("Items", 10)).size() > 0 && (list1 = tagList.getCompound(0)).contains("id", 8) && list1.getString("id").equals(InventoryUtil.itemName((Item)ItemInit.LARGE_CONTROL_CRYSTAL.get())) && list1.contains("count", 3) && list1.getInt("count") > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.dhd.has_control_crystal").withStyle(ChatFormatting.DARK_RED));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

