/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.blockstates.StargateBlockState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.items.StargateIrisItem;
import net.povstalec.sgjourney.common.misc.CoverBlockPlaceContext;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;
import net.povstalec.sgjourney.common.sgjourney.StargateBlockCover;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public abstract class AbstractStargateBlock
extends Block
implements SimpleWaterloggedBlock,
ProtectedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.create((String)"orientation", Orientation.class);
    public static final EnumProperty<StargatePart> PART = EnumProperty.create((String)"stargate_part", StargatePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected VoxelShapeProvider shapeProvider;
    protected StateDefinition<Block, BlockState> stargateStateDefinition;

    public AbstractStargateBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties);
        StateDefinition.Builder stateDefinitionBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinitionBuilder);
        this.stargateStateDefinition = stateDefinitionBuilder.create(Block::defaultBlockState, StargateBlockState::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stargateStateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ORIENTATION, (Comparable)((Object)Orientation.REGULAR))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)((Object)StargatePart.BASE)));
        this.shapeProvider = new VoxelShapeProvider(width, horizontalOffset);
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.stargateStateDefinition;
    }

    public ArrayList<StargatePart> getParts(boolean shielded) {
        return shielded ? StargatePart.DEFAULT_SHIELDED_PARTS : StargatePart.DEFAULT_PARTS;
    }

    public ArrayList<StargatePart> getParts() {
        return this.getParts(false);
    }

    public ArrayList<ShieldingPart> getShieldingParts() {
        return ShieldingPart.DEFAULT_PARTS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING}).add(new Property[]{WATERLOGGED}).add(new Property[]{ORIENTATION}).add(new Property[]{PART});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected VoxelShape shape(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        if (state.getValue(ORIENTATION) != Orientation.REGULAR) {
            return this.shapeProvider.HORIZONTAL_FULL;
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? this.shapeProvider.Z_FULL : this.shapeProvider.X_FULL;
    }

    public Optional<StargateBlockCover> getBlockCover(BlockGetter reader, BlockState state, BlockPos position) {
        AbstractStargateEntity stargate = this.getStargate(reader, position, state);
        if (stargate != null) {
            return Optional.of(stargate.blockCover);
        }
        return Optional.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Optional<StargateBlockCover> blockCover = this.getBlockCover(reader, state, pos);
        if (blockCover.isPresent()) {
            StargatePart part = (StargatePart)((Object)state.getValue(PART));
            Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
            if (coverState.isPresent()) {
                return Shapes.or((VoxelShape)this.shape(state, reader, pos, context), (VoxelShape)coverState.get().getShape(reader, pos));
            }
        }
        return this.shape(state, reader, pos, context);
    }

    public BlockState updateShape(BlockState oldState, Direction direction, BlockState newState, LevelAccessor levelAccessor, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)oldState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(oldPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(oldState, direction, newState, levelAccessor, oldPos, newPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        AbstractStargateEntity stargate = this.getStargate((BlockGetter)level, pos, state);
        if (stargate != null) {
            stargate.resetStargate(StargateInfo.Feedback.STARGATE_DESTROYED, true);
            if (!level.isClientSide() && !player.isCreative()) {
                ItemStack itemstack = new ItemStack((ItemLike)this.asItem());
                stargate.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                itementity.setUnlimitedLifetime();
                level.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void destroyStargate(Level level, BlockPos pos, ArrayList<StargatePart> parts, ArrayList<ShieldingPart> shieldingParts, Direction direction, Orientation orientation, StargatePart stargatePart) {
        if (direction == null) {
            StargateJourney.LOGGER.error("Failed to destroy Stargate because direction is null");
            return;
        }
        if (orientation == null) {
            StargateJourney.LOGGER.error("Failed to destroy Stargate because orientation is null");
            return;
        }
        AbstractShieldingBlock.destroyShielding(level, pos, shieldingParts, direction, orientation);
        for (StargatePart part : parts) {
            BlockPos ringPos;
            BlockState state;
            if (stargatePart.equals(part) || !((state = level.getBlockState(ringPos = part.getRingPos(pos, direction, orientation))).getBlock() instanceof AbstractStargateBlock)) continue;
            boolean waterlogged = state.getBlock() instanceof AbstractStargateRingBlock ? (Boolean)state.getValue((Property)AbstractStargateRingBlock.WATERLOGGED) : false;
            level.setBlock(ringPos, waterlogged ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public abstract AbstractStargateEntity getStargate(BlockGetter var1, BlockPos var2, BlockState var3);

    @Override
    public ProtectedBlockEntity getProtectedBlockEntity(BlockGetter reader, BlockPos pos, BlockState state) {
        return this.getStargate(reader, pos, state);
    }

    @Override
    public boolean hasPermissions(BlockGetter reader, BlockPos pos, BlockState state, Player player, boolean sendMessage) {
        AbstractStargateEntity stargate = this.getStargate(reader, pos, state);
        if (stargate != null) {
            return stargate.hasPermissions(player, sendMessage);
        }
        return true;
    }

    public boolean setCover(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Optional<StargateBlockCover> blockCover;
        if (!player.isShiftKeyDown() && (blockCover = this.getBlockCover((BlockGetter)level, state, pos)).isPresent()) {
            StargatePart part = (StargatePart)((Object)state.getValue(PART));
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockCover.get().getBlockAt(part).isEmpty()) {
                    CoverBlockPlaceContext context = new CoverBlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stack, result);
                    BlockState coverState = blockItem.getBlock().getStateForPlacement((BlockPlaceContext)context);
                    if (coverState != null && !(coverState.getBlock() instanceof EntityBlock)) {
                        if (!this.hasPermissions((BlockGetter)level, pos, state, player, true)) {
                            player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.protected_permissions"), true);
                        } else if (blockCover.get().setBlockAt(part, coverState)) {
                            level.playSound(player, pos, coverState.getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS);
                            if (!player.isCreative()) {
                                stack.shrink(1);
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean setIris(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        AbstractStargateEntity stargate;
        if (stack.getItem() instanceof StargateIrisItem && !level.isClientSide() && (stargate = this.getStargate((BlockGetter)level, pos, state)) != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            if (!this.hasPermissions((BlockGetter)level, pos, state, player, true)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.protected_permissions"), true);
            } else {
                if (irisStargate.irisInfo().addIris(stack)) {
                    if (!player.isCreative()) {
                        player.getItemInHand(hand).shrink(1);
                    }
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.stargate.error.already_has_iris"), true);
            }
        }
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.setCover(stack, state, level, pos, player, hand, hitResult)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (this.setIris(stack, state, level, pos, player, hand, hitResult)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Optional<StargateBlockCover> blockCover = this.getBlockCover((BlockGetter)level, state, pos);
        if (blockCover.isPresent() && !blockCover.get().blockStates.isEmpty()) {
            StargatePart part = (StargatePart)((Object)state.getValue(PART));
            if (blockCover.get().mineBlockAt(level, player, part, pos)) {
                return false;
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        Optional<StargateBlockCover> blockCover = this.getBlockCover((BlockGetter)level, state, pos);
        if (blockCover.isPresent() && !blockCover.get().blockStates.isEmpty()) {
            StargatePart part = (StargatePart)((Object)state.getValue(PART));
            ItemStack stack = blockCover.get().getStackAt(target, level, player, part, pos);
            if (!stack.isEmpty()) {
                return stack;
            }
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

