/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;

public class TollanStargateBlock
extends AbstractStargateBaseBlock {
    public TollanStargateBlock(BlockBehaviour.Properties properties) {
        super(properties, 3.0, 1.0);
    }

    @Override
    public ArrayList<StargatePart> getParts(boolean shielded) {
        return StargatePart.TOLLAN_PARTS;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        TollanStargateEntity stargate = new TollanStargateEntity(pos, state);
        return stargate;
    }

    @Override
    public AbstractStargateRingBlock getRing() {
        return (AbstractStargateRingBlock)BlockInit.TOLLAN_RING.get();
    }

    @Override
    public AbstractShieldingBlock getIris() {
        return null;
    }

    @Override
    public BlockState ringState() {
        return this.getRing().defaultBlockState();
    }

    @Override
    protected VoxelShape shape(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        if (state.getValue((Property)ORIENTATION) != Orientation.REGULAR) {
            return VoxelShapeProvider.getShapeFromArray(this.shapeProvider.BOTTOM, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue((Property)ORIENTATION)));
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? this.shapeProvider.Z_BOTTOM : this.shapeProvider.X_BOTTOM;
    }

    @Override
    public boolean setIris(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TollanStargateBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.TOLLAN_STARGATE.get(), TollanStargateEntity::tick);
    }
}

