/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.povstalec.sgjourney.common.block_entities.tech.CableBlockEntity;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCableConfig;
import net.povstalec.sgjourney.common.data.ConduitNetworks;

public abstract class CableBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<ConnectorType> NORTH = EnumProperty.create((String)"north", ConnectorType.class);
    public static final EnumProperty<ConnectorType> EAST = EnumProperty.create((String)"east", ConnectorType.class);
    public static final EnumProperty<ConnectorType> SOUTH = EnumProperty.create((String)"south", ConnectorType.class);
    public static final EnumProperty<ConnectorType> WEST = EnumProperty.create((String)"west", ConnectorType.class);
    public static final EnumProperty<ConnectorType> UP = EnumProperty.create((String)"up", ConnectorType.class);
    public static final EnumProperty<ConnectorType> DOWN = EnumProperty.create((String)"down", ConnectorType.class);
    public final VoxelShape[] shapeCache;

    public CableBlock(BlockBehaviour.Properties properties, double thickness) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeCache = this.buildShapeCache(thickness);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{WATERLOGGED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        state = this.calculateState(level, pos, state);
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)blockEntity;
            if (!this.isEdge(state)) {
                level.removeBlockEntity(pos);
                cable.setRemoved();
                level.setBlock(pos, state, 3);
                return;
            }
            BlockState otherState = level.getBlockState(fromPos);
            if (otherState.getBlock() instanceof LightningRodBlock && ((Boolean)otherState.getValue((Property)LightningRodBlock.POWERED)).booleanValue()) {
                cable.transferEnergy((Long)CommonCableConfig.lightning_strike_energy.get(), false, false);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)this.calculateState(level, pos, this.defaultBlockState()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        this.updateCable(level, pos);
        BlockState blockState = this.calculateState(level, pos, state);
        if (state != blockState) {
            level.setBlockAndUpdate(pos, blockState);
        }
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.getBlock() != newState.getBlock()) {
            ConduitNetworks.get(level).removeCable(level, pos);
            super.onRemove(oldState, level, pos, newState, isMoving);
        } else {
            super.onRemove(oldState, level, pos, newState, isMoving);
            this.updateCable(level, pos);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        ConnectorType north = CableBlock.connectorType(state, NORTH);
        ConnectorType east = CableBlock.connectorType(state, EAST);
        ConnectorType south = CableBlock.connectorType(state, SOUTH);
        ConnectorType west = CableBlock.connectorType(state, WEST);
        ConnectorType up = CableBlock.connectorType(state, UP);
        ConnectorType down = CableBlock.connectorType(state, DOWN);
        return this.shapeCache[CableBlock.bitsFromConnectors(north, east, south, west, up, down)];
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor levelAccessor, BlockPos current, BlockPos offset) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.getFluidTicks().schedule(new ScheduledTick((Object)Fluids.WATER, current, (long)Fluids.WATER.getTickDelay((LevelReader)levelAccessor), 0L));
        }
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            return this.calculateState(level, current, state);
        }
        return state;
    }

    private void updateCable(Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            ConduitNetworks.get(level).update(level, pos);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CableBlockEntity) {
                CableBlockEntity cable = (CableBlockEntity)blockEntity;
                cable.update();
            }
        }
    }

    public static ConnectorType connectionTypeTo(Level level, BlockPos pos, Direction direction) {
        BlockPos otherPos = pos.relative(direction);
        BlockState state = level.getBlockState(otherPos);
        Direction otherDirection = direction.getOpposite();
        if (state.isAir()) {
            return ConnectorType.NONE;
        }
        if (state.getBlock() instanceof CableBlock) {
            return state.getBlock() == level.getBlockState(pos).getBlock() ? ConnectorType.CABLE : ConnectorType.NONE;
        }
        BlockEntity blockEntity = level.getBlockEntity(otherPos);
        if (blockEntity != null) {
            return level.getCapability(Capabilities.EnergyStorage.BLOCK, otherPos, (Object)otherDirection) != null ? ConnectorType.BLOCK : ConnectorType.NONE;
        }
        if (state.getBlock() instanceof LightningRodBlock && state.getValue((Property)LightningRodBlock.FACING) == direction) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static ConnectorType connectorType(BlockState state, EnumProperty<ConnectorType> property) {
        try {
            return (ConnectorType)((Object)state.getValue(property));
        }
        catch (IllegalArgumentException e) {
            return ConnectorType.NONE;
        }
    }

    public static ConnectorType connectionTypeSide(BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState state = getter.getBlockState(pos);
        if (state.isAir()) {
            return ConnectorType.NONE;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> CableBlock.connectorType(state, NORTH);
            case Direction.EAST -> CableBlock.connectorType(state, EAST);
            case Direction.SOUTH -> CableBlock.connectorType(state, SOUTH);
            case Direction.WEST -> CableBlock.connectorType(state, WEST);
            case Direction.UP -> CableBlock.connectorType(state, UP);
            case Direction.DOWN -> CableBlock.connectorType(state, DOWN);
        };
    }

    protected BlockState calculateState(Level level, BlockPos pos, BlockState state) {
        ConnectorType north = CableBlock.connectionTypeTo(level, pos, Direction.NORTH);
        ConnectorType east = CableBlock.connectionTypeTo(level, pos, Direction.EAST);
        ConnectorType south = CableBlock.connectionTypeTo(level, pos, Direction.SOUTH);
        ConnectorType west = CableBlock.connectionTypeTo(level, pos, Direction.WEST);
        ConnectorType up = CableBlock.connectionTypeTo(level, pos, Direction.UP);
        ConnectorType down = CableBlock.connectionTypeTo(level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)north))).setValue(SOUTH, (Comparable)((Object)south))).setValue(WEST, (Comparable)((Object)west))).setValue(EAST, (Comparable)((Object)east))).setValue(UP, (Comparable)((Object)up))).setValue(DOWN, (Comparable)((Object)down));
    }

    public VoxelShape[] buildShapeCache(double thickness) {
        VoxelShape[] shapes = new VoxelShape[64];
        for (byte i = 0; i < 64; i = (byte)(i + 1)) {
            shapes[i] = this.shapeFromBits(thickness, i);
        }
        return shapes;
    }

    public static VoxelShape centerShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)sideSpace, (double)sideSpace, (double)sideSpace, (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)(sideSpace + thickness));
    }

    public static VoxelShape northShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)sideSpace, (double)sideSpace, (double)0.0, (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)sideSpace);
    }

    public static VoxelShape southShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)sideSpace, (double)sideSpace, (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)1.0);
    }

    public static VoxelShape westShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)0.0, (double)sideSpace, (double)sideSpace, (double)sideSpace, (double)(sideSpace + thickness), (double)(sideSpace + thickness));
    }

    public static VoxelShape eastShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)(sideSpace + thickness), (double)sideSpace, (double)sideSpace, (double)1.0, (double)(sideSpace + thickness), (double)(sideSpace + thickness));
    }

    public static VoxelShape upShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)sideSpace, (double)(sideSpace + thickness), (double)sideSpace, (double)(sideSpace + thickness), (double)1.0, (double)(sideSpace + thickness));
    }

    public static VoxelShape downShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.box((double)sideSpace, (double)0.0, (double)sideSpace, (double)(sideSpace + thickness), (double)sideSpace, (double)(sideSpace + thickness));
    }

    public VoxelShape shapeFromBits(double thickness, byte bits) {
        VoxelShape shape = CableBlock.centerShape(thickness);
        if ((1 & bits) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CableBlock.northShape(thickness));
        }
        if ((2 & bits) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CableBlock.eastShape(thickness));
        }
        if ((4 & bits) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CableBlock.southShape(thickness));
        }
        if ((8 & bits) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CableBlock.westShape(thickness));
        }
        if ((0x10 & bits) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CableBlock.upShape(thickness));
        }
        if ((0x20 & bits) != 0) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CableBlock.downShape(thickness));
        }
        return shape;
    }

    public static byte bitsFromConnectors(ConnectorType north, ConnectorType east, ConnectorType south, ConnectorType west, ConnectorType up, ConnectorType down) {
        byte bits = 0;
        if (north != ConnectorType.NONE) {
            bits = (byte)(bits | 1);
        }
        if (east != ConnectorType.NONE) {
            bits = (byte)(bits | 2);
        }
        if (south != ConnectorType.NONE) {
            bits = (byte)(bits | 4);
        }
        if (west != ConnectorType.NONE) {
            bits = (byte)(bits | 8);
        }
        if (up != ConnectorType.NONE) {
            bits = (byte)(bits | 0x10);
        }
        if (down != ConnectorType.NONE) {
            bits = (byte)(bits | 0x20);
        }
        return bits;
    }

    public boolean isEdge(BlockState state) {
        return CableBlock.connectorType(state, NORTH).isEdge() || CableBlock.connectorType(state, EAST).isEdge() || CableBlock.connectorType(state, SOUTH).isEdge() || CableBlock.connectorType(state, WEST).isEdge() || CableBlock.connectorType(state, UP).isEdge() || CableBlock.connectorType(state, DOWN).isEdge();
    }

    public abstract long energyTransfer();

    public abstract boolean transfersZeroPointEnergy();

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.transfersZeroPointEnergy()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.cable.zpm_transfer").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy_transfer").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(this.energyTransfer()) + "/t"))).withStyle(ChatFormatting.RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static enum ConnectorType implements StringRepresentable
    {
        BLOCK("block", true),
        CABLE("cable", false),
        NONE("none", false);

        private String name;
        private boolean isEdge;

        private ConnectorType(String name, boolean isEdge) {
            this.name = name;
            this.isEdge = isEdge;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean isEdge() {
            return this.isEdge;
        }
    }

    public static class LargeNaquadahCable
    extends CableBlock {
        public LargeNaquadahCable(BlockBehaviour.Properties properties) {
            super(properties, 0.5);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.LargeNaquadahCable(pos, state) : null;
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.large_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.large_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class MediumNaquadahCable
    extends CableBlock {
        public MediumNaquadahCable(BlockBehaviour.Properties properties) {
            super(properties, 0.375);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.MediumNaquadahCable(pos, state) : null;
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.medium_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.medium_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class SmallNaquadahCable
    extends CableBlock {
        public SmallNaquadahCable(BlockBehaviour.Properties properties) {
            super(properties, 0.25);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.SmallNaquadahCable(pos, state) : null;
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.small_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.small_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class NaquadahWire
    extends CableBlock {
        public final VoxelShape[] collisionShapeCache = this.buildShapeCache(0.125);

        public NaquadahWire(BlockBehaviour.Properties properties) {
            super(properties, 0.25);
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.NaquadahWire(pos, state) : null;
        }

        public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
            ConnectorType north = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)NORTH);
            ConnectorType east = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)EAST);
            ConnectorType south = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)SOUTH);
            ConnectorType west = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)WEST);
            ConnectorType up = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)UP);
            ConnectorType down = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)DOWN);
            return this.collisionShapeCache[NaquadahWire.bitsFromConnectors(north, east, south, west, up, down)];
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.naquadah_wire_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.naquadah_wire_transfers_zero_point_energy.get();
        }
    }
}

