/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.block_entities.tech.NaquadahGeneratorEntity;
import net.povstalec.sgjourney.common.block_entities.tech.NaquadahGeneratorMarkIEntity;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorBlock;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;
import org.joml.Vector3d;

public class NaquadahGeneratorMarkIBlock
extends NaquadahGeneratorBlock {
    private static final ArrayList<Tuple<Vector3d, Vector3d>> MIN_MAX = new ArrayList<Tuple>(Arrays.asList(new Tuple((Object)new Vector3d(5.5, 5.5, 14.0), (Object)new Vector3d(10.5, 10.5, 16.0)), new Tuple((Object)new Vector3d(6.5, 6.5, 13.0), (Object)new Vector3d(9.5, 9.5, 14.0)), new Tuple((Object)new Vector3d(4.0, 6.5, 10.0), (Object)new Vector3d(12.0, 9.5, 13.0)), new Tuple((Object)new Vector3d(12.0, 6.0, 9.5), (Object)new Vector3d(16.0, 10.0, 13.5)), new Tuple((Object)new Vector3d(0.0, 6.0, 9.5), (Object)new Vector3d(4.0, 10.0, 13.5)), new Tuple((Object)new Vector3d(6.5, 6.5, 9.0), (Object)new Vector3d(9.5, 9.5, 10.0)), new Tuple((Object)new Vector3d(5.5, 5.5, 8.0), (Object)new Vector3d(10.5, 10.5, 9.0)), new Tuple((Object)new Vector3d(6.5, 6.5, 7.0), (Object)new Vector3d(9.5, 9.5, 8.0))));
    private static final VoxelShape SHAPE_NORTH_UP = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.NORTH_UP);
    private static final VoxelShape SHAPE_EAST_UP = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.EAST_UP);
    private static final VoxelShape SHAPE_SOUTH_UP = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.SOUTH_UP);
    private static final VoxelShape SHAPE_WEST_UP = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.WEST_UP);
    private static final VoxelShape SHAPE_UP_NORTH = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.UP_NORTH);
    private static final VoxelShape SHAPE_UP_EAST = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.UP_EAST);
    private static final VoxelShape SHAPE_UP_SOUTH = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.UP_SOUTH);
    private static final VoxelShape SHAPE_UP_WEST = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.UP_WEST);
    private static final VoxelShape SHAPE_DOWN_NORTH = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.DOWN_NORTH);
    private static final VoxelShape SHAPE_DOWN_EAST = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.DOWN_EAST);
    private static final VoxelShape SHAPE_DOWN_SOUTH = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.DOWN_SOUTH);
    private static final VoxelShape SHAPE_DOWN_WEST = VoxelShapeProvider.getOrientedShapes(MIN_MAX, FrontAndTop.DOWN_WEST);
    public static final MapCodec<NaquadahGeneratorMarkIBlock> CODEC = NaquadahGeneratorMarkIBlock.simpleCodec(NaquadahGeneratorMarkIBlock::new);

    public NaquadahGeneratorMarkIBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<NaquadahGeneratorMarkIBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NaquadahGeneratorMarkIEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return switch ((FrontAndTop)state.getValue((Property)ORIENTATION)) {
            case FrontAndTop.NORTH_UP -> SHAPE_NORTH_UP;
            case FrontAndTop.EAST_UP -> SHAPE_EAST_UP;
            case FrontAndTop.SOUTH_UP -> SHAPE_SOUTH_UP;
            case FrontAndTop.WEST_UP -> SHAPE_WEST_UP;
            case FrontAndTop.UP_NORTH -> SHAPE_UP_NORTH;
            case FrontAndTop.UP_EAST -> SHAPE_UP_EAST;
            case FrontAndTop.UP_SOUTH -> SHAPE_UP_SOUTH;
            case FrontAndTop.UP_WEST -> SHAPE_UP_WEST;
            case FrontAndTop.DOWN_NORTH -> SHAPE_DOWN_NORTH;
            case FrontAndTop.DOWN_EAST -> SHAPE_DOWN_EAST;
            case FrontAndTop.DOWN_SOUTH -> SHAPE_DOWN_SOUTH;
            case FrontAndTop.DOWN_WEST -> SHAPE_DOWN_WEST;
            default -> SHAPE_NORTH_UP;
        };
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof NaquadahGeneratorEntity && !level.isClientSide && !player.isCreative()) {
            ItemStack itemstack = new ItemStack((ItemLike)BlockInit.NAQUADAH_GENERATOR_MARK_I.get());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return NaquadahGeneratorMarkIBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.NAQUADAH_GENERATOR_MARK_I.get()), NaquadahGeneratorEntity::tick);
    }

    @Override
    public long energyPerTick() {
        return (Long)CommonNaquadahGeneratorConfig.naquadah_generator_mark_i_energy_per_tick.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"block.sgjourney.naquadah_generator_mark_i.description.mode").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }
}

