/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.init.AttachmentTypeInit;

public class AncientGene {
    public static final String ANCIENT_GENE = "ancient_gene";
    public static final Codec CODEC = StringRepresentable.fromValues(() -> new ATAGene[]{ATAGene.ANCIENT, ATAGene.INHERITED, ATAGene.ARTIFICIAL, ATAGene.NONE, ATAGene.UNDECIDED});
    public static final EntityCapability<AncientGene, Void> ANCIENT_GENE_CAPABILITY = EntityCapability.createVoid((ResourceLocation)StargateJourney.sgjourneyLocation("ancient_gene"), AncientGene.class);
    private LivingEntity entity;
    private ATAGene gene;

    public AncientGene(LivingEntity entity) {
        this.entity = entity;
        this.gene = (ATAGene)((Object)this.entity.getData(AttachmentTypeInit.ATA_GENE));
    }

    public ATAGene getGeneType() {
        return this.gene;
    }

    public boolean canUseAncientTechnology() {
        return this.gene.canActivate();
    }

    public boolean isAncient() {
        return this.gene.equals((Object)ATAGene.ANCIENT);
    }

    public boolean isInherited() {
        return this.gene.equals((Object)ATAGene.INHERITED);
    }

    public boolean isArtificial() {
        return this.gene.equals((Object)ATAGene.ARTIFICIAL);
    }

    public boolean isLacking() {
        return this.gene.equals((Object)ATAGene.NONE);
    }

    public void setGene(ATAGene gene) {
        this.gene = gene;
        this.entity.setData(AttachmentTypeInit.ATA_GENE, (Object)this.gene);
    }

    public void giveGene() {
        this.setGene(ATAGene.ANCIENT);
    }

    public void inheritGene() {
        this.setGene(ATAGene.INHERITED);
    }

    public void implantGene() {
        this.setGene(ATAGene.ARTIFICIAL);
    }

    public void removeGene() {
        this.setGene(ATAGene.NONE);
    }

    public static void inheritGene(long seed, Entity entity, int inheritanceChance) {
        Random random = new Random(seed);
        int chance = random.nextInt(1, 101);
        AncientGene.inheritGene(entity, inheritanceChance, chance);
    }

    public static void inheritGene(Entity entity, int inheritanceChance) {
        Random random = new Random();
        int chance = random.nextInt(1, 101);
        AncientGene.inheritGene(entity, inheritanceChance, chance);
    }

    private static void inheritGene(Entity entity, int inheritanceChance, int chance) {
        AncientGene cap = (AncientGene)entity.getCapability(ANCIENT_GENE_CAPABILITY);
        if (cap != null && cap.firstJoin()) {
            if (chance <= inheritanceChance) {
                cap.inheritGene();
            } else {
                cap.setGene(ATAGene.NONE);
            }
        }
    }

    public boolean firstJoin() {
        return this.getGeneType() == ATAGene.UNDECIDED;
    }

    public void copyFrom(AncientGene source) {
        this.setGene(source.gene);
    }

    public static enum ATAGene implements StringRepresentable
    {
        ANCIENT("ancient", true),
        INHERITED("inherited", true),
        ARTIFICIAL("artificial", true),
        NONE("none", false),
        UNDECIDED("undecided", false);

        private final String name;
        private boolean canActivate;

        private ATAGene(String name, boolean canActivate) {
            this.name = name;
            this.canActivate = canActivate;
        }

        public String getSerializedName() {
            return this.name;
        }

        private boolean canActivate() {
            return this.canActivate;
        }
    }
}

