/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.jei;

import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.items.StargateUpgradeItem;
import net.povstalec.sgjourney.common.items.StargateVariantItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SGJourneyItemSubtypeInterpreter
implements ISubtypeInterpreter<ItemStack> {
    public static final SGJourneyItemSubtypeInterpreter INSTANCE = new SGJourneyItemSubtypeInterpreter();

    @Nullable
    public Object getSubtypeData(ItemStack ingredient, UidContext context) {
        if (ingredient.getItem() instanceof StargateVariantItem) {
            return ingredient.get(DataComponentInit.STARGATE_VARIANT);
        }
        return ingredient.getItem() instanceof StargateUpgradeItem ? ingredient.get(DataComponentInit.STARGATE_UPGRADE) : null;
    }

    @NotNull
    public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
        ResourceLocation path;
        String subtypeInfo = "";
        if (ingredient.getItem() instanceof StargateVariantItem) {
            ResourceLocation path2 = (ResourceLocation)ingredient.get(DataComponentInit.STARGATE_VARIANT);
            if (path2 != null) {
                subtypeInfo = path2.toString();
            }
        } else if (ingredient.getItem() instanceof StargateUpgradeItem && (path = (ResourceLocation)ingredient.get(DataComponentInit.STARGATE_UPGRADE)) != null) {
            subtypeInfo = path.toString();
        }
        return subtypeInfo;
    }
}

