/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public final class StargateNetwork
extends SavedData {
    private static boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    private static final String FILE_NAME = "sgjourney-stargate_network";
    private static final String VERSION = "version";
    private static final String CONNECTIONS = "connections";
    private static final int updateVersion = 17;
    private MinecraftServer server;
    private HashMap<UUID, StargateConnection> connections = new HashMap();
    private int version = 0;

    public final int getVersion() {
        return this.version;
    }

    private final void updateVersion() {
        this.version = 17;
    }

    public final void updateNetwork(MinecraftServer server) {
        if (this.getVersion() == 17) {
            StargateJourney.LOGGER.debug("Stargate Network is up to date (Version: " + this.version + ")");
            return;
        }
        StargateJourney.LOGGER.debug("Detected an incompatible Stargate Network version (Version: " + this.getVersion() + ") - updating to version 17");
        this.stellarUpdate(server, false);
    }

    public final void eraseNetwork() {
        this.connections.clear();
        this.setDirty();
    }

    public final boolean shouldUseDatapackAddresses() {
        return StargateNetworkSettings.get(this.server).useDatapackAddresses();
    }

    public final void stellarUpdate(MinecraftServer server, boolean updateInterfaces) {
        for (Map.Entry<UUID, StargateConnection> nextConnection : this.connections.entrySet()) {
            StargateConnection connection = nextConnection.getValue();
            connection.terminate(server, StargateInfo.Feedback.CONNECTION_ENDED_BY_NETWORK);
        }
        StargateJourney.LOGGER.debug("Connections terminated");
        StargateNetworkSettings.get(server).updateSettings();
        HashMap<ResourceLocation, Address.Immutable> primaryStargates = Universe.get(server).getPrimaryStargateAddresses();
        Universe.get(server).eraseUniverseInfo();
        StargateJourney.LOGGER.debug("Universe erased");
        Universe.get(server).generateUniverseInfo(server);
        Universe.get(server).setPrimaryStargateAddresses(primaryStargates);
        StargateJourney.LOGGER.debug("Universe regenerated");
        this.eraseNetwork();
        StargateJourney.LOGGER.debug("Stargate Network erased");
        this.resetStargates(server, updateInterfaces);
        StargateJourney.LOGGER.debug("Stargates reset");
        this.updateVersion();
        StargateJourney.LOGGER.debug("Version updated");
        this.setDirty();
    }

    public final void addStargates(MinecraftServer server) {
        HashMap<Address.Immutable, Stargate> stargates = BlockEntityList.get(server).getStargates();
        stargates.entrySet().stream().forEach(stargateInfo -> {
            Stargate stargate = (Stargate)stargateInfo.getValue();
            if (stargate != null) {
                this.addStargate(stargate);
            }
        });
    }

    private final void resetStargates(MinecraftServer server, boolean updateInterfaces) {
        HashMap<Address.Immutable, Stargate> stargates = BlockEntityList.get(server).getStargates();
        stargates.entrySet().stream().forEach(stargateInfo -> {
            Address.Immutable address = (Address.Immutable)stargateInfo.getKey();
            Stargate stargate = (Stargate)stargateInfo.getValue();
            if (stargate != null) {
                if (stargate.isValid(server)) {
                    if (!address.equals(stargate.get9ChevronAddress())) {
                        this.removeStargate(stargate);
                    }
                    stargate.resetStargate(server, StargateInfo.Feedback.CONNECTION_ENDED_BY_NETWORK, updateInterfaces);
                    this.addStargate(stargate);
                    stargate.update(server);
                    stargate.updateInterfaceBlocks(server, null, null, new Object[0]);
                } else {
                    this.removeStargate(stargate);
                }
            } else {
                BlockEntityList.get(server).removeStargate(address);
            }
        });
    }

    public final void addStargate(Stargate stargate) {
        if (stargate == null) {
            return;
        }
        Universe.get(this.server).addStargateToDimension(stargate.getDimension(), stargate);
        this.setDirty();
    }

    public final void addStargate(AbstractStargateEntity stargateEntity) {
        this.addStargate(BlockEntityList.get(this.server).addStargate(stargateEntity));
    }

    public final void removeStargate(Stargate stargate) {
        if (stargate != null) {
            Universe.get(this.server).removeStargateFromSolarSystem(stargate.getSolarSystem(this.server), stargate);
            BlockEntityList.get(this.server).removeStargate(stargate.get9ChevronAddress());
            StargateJourney.LOGGER.debug("Removed " + stargate.get9ChevronAddress().toString() + " from Stargate Network");
            this.setDirty();
        } else {
            StargateJourney.LOGGER.error("Could not remove Stargate because it's null");
        }
    }

    public final void removeStargate(Address.Immutable address) {
        if (address == null) {
            return;
        }
        Stargate stargate = this.getStargate(address);
        this.removeStargate(stargate);
    }

    public final void updateStargate(ServerLevel level, AbstractStargateEntity stargateEntity) {
        Stargate stargate = this.getStargate(stargateEntity.get9ChevronAddress());
        if (stargate != null) {
            Universe.get(this.server).removeStargateFromDimension((ResourceKey<Level>)level.dimension(), stargate);
            stargate.update(this.server);
            Universe.get(this.server).addStargateToDimension((ResourceKey<Level>)level.dimension(), stargate);
        }
    }

    @Nullable
    public final Stargate getStargate(Address address) {
        return BlockEntityList.get(this.server).getStargate(address);
    }

    public final void handleConnections() {
        HashMap<UUID, StargateConnection> connections = new HashMap<UUID, StargateConnection>();
        connections.putAll(this.connections);
        connections.forEach((uuid, connection) -> connection.tick(this.server));
        this.setDirty();
    }

    public final int getOpenTime(UUID uuid) {
        if (this.connections.containsKey(uuid)) {
            return this.connections.get(uuid).getOpenTime();
        }
        return 0;
    }

    public final int getTimeSinceLastTraveler(UUID uuid) {
        if (this.connections.containsKey(uuid)) {
            return this.connections.get(uuid).getTimeSinceLastTraveler();
        }
        return 0;
    }

    public final StargateInfo.Feedback createConnection(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate, Address.Type addressType, boolean doKawoosh) {
        StargateConnection connection;
        StargateConnection.Type connectionType = StargateConnection.getType(server, dialingStargate, dialedStargate);
        if (SGJourneyEvents.onStargateConnect(server, dialingStargate, dialedStargate, connectionType, addressType, doKawoosh)) {
            return StargateInfo.Feedback.NONE;
        }
        if (!dialedStargate.isValid(server)) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.COULD_NOT_REACH_TARGET_STARGATE, true);
        }
        if (!((Boolean)CommonStargateConfig.allow_interstellar_8_chevron_addresses.get()).booleanValue() && addressType == Address.Type.ADDRESS_8_CHEVRON && connectionType == StargateConnection.Type.INTERSTELLAR) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.INVALID_8_CHEVRON_ADDRESS, true);
        }
        if (!((Boolean)CommonStargateConfig.allow_system_wide_connections.get()).booleanValue() && connectionType == StargateConnection.Type.SYSTEM_WIDE) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.INVALID_SYSTEM_WIDE_CONNECTION, true);
        }
        if (dialingStargate.equals(dialedStargate)) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.SELF_DIAL, true);
        }
        if (dialedStargate.isConnected(server)) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.ALREADY_CONNECTED, true);
        }
        if (dialedStargate.isObstructed(server)) {
            return dialingStargate.resetStargate(server, StargateInfo.Feedback.TARGET_OBSTRUCTED, true);
        }
        if (requireEnergy) {
            if (StargateConnection.canExtract(server, dialingStargate, connectionType.getEstablishingPowerCost())) {
                dialingStargate.extractEnergy(server, connectionType.getEstablishingPowerCost(), false);
            } else {
                return dialingStargate.resetStargate(server, StargateInfo.Feedback.NOT_ENOUGH_POWER, true);
            }
        }
        if ((connection = StargateConnection.create(server, connectionType, dialingStargate, dialedStargate, doKawoosh)) != null) {
            this.addConnection(connection);
            switch (connectionType) {
                case SYSTEM_WIDE: {
                    return StargateInfo.Feedback.CONNECTION_ESTABLISHED_SYSTEM_WIDE;
                }
                case INTERSTELLAR: {
                    return StargateInfo.Feedback.CONNECTION_ESTABLISHED_INTERSTELLAR;
                }
            }
            return StargateInfo.Feedback.CONNECTION_ESTABLISHED_INTERGALACTIC;
        }
        return StargateInfo.Feedback.COULD_NOT_REACH_TARGET_STARGATE;
    }

    public final boolean addConnection(StargateConnection connection) {
        if (!this.connections.containsKey(connection.getID())) {
            this.connections.put(connection.getID(), connection);
            SGJourneyEvents.onConnectionEstablished(this.server, connection);
            return true;
        }
        return false;
    }

    public final boolean hasConnection(UUID uuid) {
        return this.connections.containsKey(uuid);
    }

    public final void terminateConnection(UUID uuid, StargateInfo.Feedback feedback) {
        if (!this.hasConnection(uuid)) {
            return;
        }
        this.connections.get(uuid).terminate(this.server, feedback);
    }

    public final void removeConnection(UUID uuid) {
        if (this.hasConnection(uuid)) {
            this.connections.remove(uuid);
            StargateJourney.LOGGER.debug("Removed connection " + String.valueOf(uuid));
        } else {
            StargateJourney.LOGGER.error("Could not find connection " + String.valueOf(uuid));
        }
        this.setDirty();
    }

    public final void printConnections() {
        System.out.println("[Connections]");
        this.connections.entrySet().stream().forEach(connectionEntry -> ((StargateConnection)connectionEntry.getValue()).printConnection());
    }

    public final boolean sendStargateMessage(AbstractStargateEntity sendingStargate, UUID uuid, String messsage) {
        if (this.hasConnection(uuid)) {
            this.connections.get(uuid).sendStargateMessage(this.server, sendingStargate, messsage);
            return true;
        }
        return false;
    }

    public final void sendStargateTransmission(AbstractStargateEntity sendingStargate, UUID uuid, int transmissionJumps, int frequency, String transmission) {
        if (this.hasConnection(uuid)) {
            this.connections.get(uuid).sendStargateTransmission(this.server, sendingStargate, transmissionJumps, frequency, transmission);
        }
    }

    public final float checkStargateShieldingState(AbstractStargateEntity sendingStargate, UUID uuid) {
        if (this.hasConnection(uuid)) {
            return this.connections.get(uuid).checkStargateShieldingState(this.server, sendingStargate);
        }
        return 0.0f;
    }

    private static boolean addStargatesFromChunk(ServerLevel level, int x, int z, List<AbstractStargateEntity> stargates) {
        LevelChunk chunk = level.getChunk(x, z);
        for (BlockPos pos : chunk.getBlockEntitiesPos()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof AbstractStargateEntity)) continue;
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            stargates.add(stargate);
            return true;
        }
        return false;
    }

    private static void searchEdges(ServerLevel level, int xCenter, int yCenter, int radius, List<AbstractStargateEntity> stargates) {
        if (radius == 0) {
            StargateNetwork.addStargatesFromChunk(level, xCenter, yCenter, stargates);
        } else {
            int y;
            int x;
            int xMin = xCenter - radius;
            int xMax = xCenter + radius;
            int yMin = yCenter - radius;
            int yMax = yCenter + radius;
            for (x = xMin; x <= xMax; ++x) {
                if (!StargateNetwork.addStargatesFromChunk(level, x, yMax, stargates)) continue;
                return;
            }
            for (y = yMax - 1; y >= yMin + 1; --y) {
                if (!StargateNetwork.addStargatesFromChunk(level, xMax, y, stargates)) continue;
                return;
            }
            for (x = xMax; x >= xMin; --x) {
                if (!StargateNetwork.addStargatesFromChunk(level, x, yMin, stargates)) continue;
                return;
            }
            for (y = yMin + 1; y <= yMax - 1; ++y) {
                if (!StargateNetwork.addStargatesFromChunk(level, xMin, y, stargates)) continue;
                return;
            }
        }
    }

    public static void findStargates(ServerLevel level) {
        StargateJourney.LOGGER.debug("Attempting to locate the Stargate Structure in " + String.valueOf(level.dimension().location()));
        int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
        int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
        BlockPos blockpos = level.findNearestMapStructure(CommonGenerationConfig.common_stargate_search.get() ? TagInit.Structures.HAS_STARGATE : TagInit.Structures.NETWORK_STARGATE, new BlockPos(xOffset * 16, 0, zOffset * 16), 150, false);
        if (blockpos == null) {
            StargateJourney.LOGGER.debug("Stargate Structure not found");
            return;
        }
        ArrayList<AbstractStargateEntity> stargates = new ArrayList<AbstractStargateEntity>();
        int xCenter = SectionPos.blockToSectionCoord((int)blockpos.getX());
        int zCenter = SectionPos.blockToSectionCoord((int)blockpos.getZ());
        for (int radius = 0; radius <= 2; ++radius) {
            StargateNetwork.searchEdges(level, xCenter, zCenter, radius, stargates);
        }
        if (stargates.isEmpty()) {
            StargateJourney.LOGGER.debug("No Stargates found in Stargate Structure");
            return;
        }
        for (AbstractStargateEntity stargate : stargates) {
            stargate.onLoad();
        }
    }

    private final CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putInt(VERSION, this.version);
        tag.put(CONNECTIONS, (Tag)this.serializeConnections());
        return tag;
    }

    private final CompoundTag serializeConnections() {
        CompoundTag connectionsTag = new CompoundTag();
        this.connections.forEach((connectionID, connection) -> connectionsTag.put(connectionID.toString(), (Tag)connection.serialize()));
        return connectionsTag;
    }

    private final void deserialize(CompoundTag tag) {
        this.version = tag.getInt(VERSION);
        this.deserializeConnections(tag.getCompound(CONNECTIONS));
    }

    private final void deserializeConnections(CompoundTag tag) {
        for (String connectionID : tag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(connectionID);
                StargateConnection connection = StargateConnection.deserialize(this.server, uuid, tag.getCompound(connectionID));
                if (connection == null) continue;
                this.connections.put(uuid, connection);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public StargateNetwork(MinecraftServer server) {
        this.server = server;
    }

    public static StargateNetwork create(MinecraftServer server) {
        return new StargateNetwork(server);
    }

    public static StargateNetwork load(MinecraftServer server, CompoundTag tag) {
        StargateNetwork data = StargateNetwork.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag = this.serialize();
        return tag;
    }

    public static SavedData.Factory<StargateNetwork> dataFactory(MinecraftServer server) {
        return new SavedData.Factory(() -> StargateNetwork.create(server), (tag, provider) -> StargateNetwork.load(server, tag));
    }

    @Nonnull
    public static StargateNetwork get(Level level) {
        if (level.isClientSide()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return StargateNetwork.get(level.getServer());
    }

    @Nonnull
    public static StargateNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (StargateNetwork)storage.computeIfAbsent(StargateNetwork.dataFactory(server), FILE_NAME);
    }
}

