/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.items.crystals.MemoryCrystalItem;

public class CrystalReaderItem
extends Item {
    public CrystalReaderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Item item;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack offHandItem = player.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (offHandItem.getItem() instanceof CrystalReaderItem && (item = mainHandItem.getItem()) instanceof MemoryCrystalItem) {
            AbstractTransporterEntity transporter;
            MemoryCrystalItem memoryCrystal = (MemoryCrystalItem)item;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractTransporterEntity && (transporter = (AbstractTransporterEntity)blockEntity).getID() != null) {
                memoryCrystal.saveUUID(mainHandItem, transporter.getID());
                player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.memory_crystal.saved_id").withStyle(ChatFormatting.BLUE), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        Item item;
        if (!level.isClientSide()) {
            return super.use(level, player, usedHand);
        }
        ItemStack offHandStack = player.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainHandStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (offHandStack.getItem() instanceof CrystalReaderItem && (item = mainHandStack.getItem()) instanceof MemoryCrystalItem) {
            MemoryCrystalItem memoryCrystal = (MemoryCrystalItem)item;
            ListTag list = MemoryCrystalItem.getMemoryList(mainHandStack);
            for (int i = 0; i < list.size(); ++i) {
                player.sendSystemMessage((Component)Component.literal((String)memoryCrystal.memoryStringAt(list, i)));
            }
        }
        return super.use(level, player, usedHand);
    }
}

