/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.povstalec.sgjourney.common.capabilities.SingleItemHandler;
import net.povstalec.sgjourney.common.init.FluidInit;
import org.jetbrains.annotations.NotNull;

public abstract class FluidItem
extends Item {
    public FluidItem(Item.Properties properties) {
        super(properties);
    }

    public float getFluidPercentage(ItemStack stack) {
        if (this.getFluidCapacity(stack) <= 0) {
            return 0.0f;
        }
        return (float)this.getFluidAmount(stack) / (float)this.getFluidCapacity(stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * this.getFluidPercentage(stack));
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, this.getFluidPercentage(stack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public abstract boolean isCorrectFluid(FluidStack var1);

    public abstract int getFluidCapacity(ItemStack var1);

    public FluidStack getFluidStack(ItemStack stack) {
        IFluidHandler fluidHandler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return FluidStack.EMPTY;
        }
        return fluidHandler.getFluidInTank(0);
    }

    public int getFluidAmount(ItemStack stack) {
        return this.getFluidStack(stack).getAmount();
    }

    public void drainFluid(ItemStack stack, int amount) {
        IFluidHandler fluidHandler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected ChatFormatting fluidComponentColor(FluidStack fluidStack) {
        if (fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get()) {
            return ChatFormatting.GREEN;
        }
        if (fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()) {
            return ChatFormatting.DARK_GREEN;
        }
        return ChatFormatting.WHITE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        FluidStack fluidStack = this.getFluidStack(stack);
        MutableComponent fluidComponent = Component.translatable((String)"tooltip.sgjourney.fluid").append((Component)Component.literal((String)": "));
        if (fluidStack.isEmpty()) {
            fluidComponent.append("0 mB");
        } else {
            fluidComponent.append(fluidStack.getFluidType().getDescription());
            fluidComponent.append((Component)Component.literal((String)(" " + fluidStack.getAmount() + "mB")));
        }
        fluidComponent.withStyle(this.fluidComponentColor(fluidStack));
        tooltipComponents.add((Component)fluidComponent);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static ItemStack fluidSetup(Item item, Fluid fluid, int amount) {
        ItemStack stack = new ItemStack((ItemLike)item);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            fluidHandler.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
        }
        return stack;
    }

    public static abstract class Holder
    extends FluidItem {
        public Holder(Item.Properties properties) {
            super(properties);
        }

        public abstract ItemStack getHeldItem(ItemStack var1);

        public abstract boolean isValidItem(ItemStack var1);

        @Override
        public int getFluidCapacity(ItemStack stack) {
            Item item = this.getHeldItem(stack).getItem();
            if (item instanceof FluidItem) {
                FluidItem fluidItem = (FluidItem)item;
                return fluidItem.getFluidCapacity(stack);
            }
            return 0;
        }

        @Override
        public FluidStack getFluidStack(ItemStack stack) {
            Item item;
            ItemStack heldStack = this.getHeldItem(stack);
            if (!heldStack.isEmpty() && (item = heldStack.getItem()) instanceof FluidItem) {
                FluidItem fluidItem = (FluidItem)item;
                if (this.isValidItem(heldStack)) {
                    return fluidItem.getFluidStack(heldStack);
                }
            }
            return FluidStack.EMPTY;
        }

        public boolean swapItem(Player player, ItemStack holderStack, ItemStack insertedStack) {
            IItemHandler itemHandler = (IItemHandler)holderStack.getCapability(Capabilities.ItemHandler.ITEM);
            if (itemHandler != null && (insertedStack.isEmpty() || this.isValidItem(insertedStack))) {
                ItemStack returnStack = itemHandler.extractItem(0, 1, false);
                itemHandler.insertItem(0, insertedStack, false);
                player.setItemInHand(InteractionHand.MAIN_HAND, returnStack);
                return true;
            }
            return false;
        }

        @NotNull
        public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
            ItemStack offHandStack = player.getItemInHand(InteractionHand.OFF_HAND);
            Item item = offHandStack.getItem();
            if (item instanceof Holder) {
                Holder holder = (Holder)item;
                if (!level.isClientSide() && holder.swapItem(player, offHandStack, player.getItemInHand(InteractionHand.MAIN_HAND))) {
                    return InteractionResultHolder.success((Object)offHandStack);
                }
            }
            return super.use(level, player, hand);
        }

        @Override
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            ItemStack heldItem = this.getHeldItem(stack);
            MutableComponent itemComponent = Component.translatable((String)"tooltip.sgjourney.holding").append((Component)Component.literal((String)": "));
            if (heldItem.isEmpty()) {
                itemComponent.append("[-]");
            } else {
                itemComponent.append(heldItem.getDisplayName());
            }
            tooltipComponents.add((Component)itemComponent);
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }

        public static abstract class FluidItemHandler
        extends SingleItemHandler
        implements IFluidHandlerItem {
            protected ItemStack stack;

            public FluidItemHandler(ItemStack stack, DataComponentType<ItemContainerContents> component) {
                super((MutableDataComponentHolder)stack, component);
                this.stack = stack;
            }

            @NotNull
            public ItemStack getContainer() {
                return this.stack;
            }

            public int getTanks() {
                return 0;
            }

            @NotNull
            public FluidStack getFluidInTank(int i) {
                if (!this.hasItem()) {
                    return FluidStack.EMPTY;
                }
                ItemStack heldStack = this.getHeldItem();
                Item item = heldStack.getItem();
                if (item instanceof FluidItem) {
                    FluidItem fluidItem = (FluidItem)item;
                    return fluidItem.getFluidStack(heldStack);
                }
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int i) {
                if (!this.hasItem()) {
                    return 0;
                }
                ItemStack heldStack = this.getHeldItem();
                Item item = heldStack.getItem();
                if (item instanceof FluidItem) {
                    FluidItem fluidItem = (FluidItem)item;
                    return fluidItem.getFluidCapacity(heldStack);
                }
                return 0;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!this.hasItem()) {
                    return 0;
                }
                ItemStack heldStack = this.getHeldItem();
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)heldStack.getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidHandler != null) {
                    int amount = fluidHandler.fill(resource, action);
                    if (amount != 0) {
                        this.updateContents(heldStack);
                    }
                    return amount;
                }
                return 0;
            }

            @NotNull
            public FluidStack deplete(int maxDrain, IFluidHandler.FluidAction action) {
                if (!this.hasItem()) {
                    return FluidStack.EMPTY;
                }
                ItemStack heldStack = this.getHeldItem();
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)heldStack.getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidHandler != null) {
                    FluidStack fluidStack = fluidHandler.drain(maxDrain, action);
                    if (!fluidStack.isEmpty()) {
                        this.updateContents(heldStack);
                    }
                    return fluidStack;
                }
                return FluidStack.EMPTY;
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction fluidAction) {
                if (this.stack.getCount() != 1 || resource.isEmpty() || !resource.is(this.getFluidInTank(0).getFluid())) {
                    return FluidStack.EMPTY;
                }
                return this.drain(resource.getAmount(), fluidAction);
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
                return FluidStack.EMPTY;
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
                Item item = this.stack.getItem();
                if (item instanceof FluidItem) {
                    FluidItem fluidItem = (FluidItem)item;
                    return fluidItem.isCorrectFluid(fluidStack);
                }
                return false;
            }
        }
    }
}

