/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.packets.ClientboundGDOOpenScreenPacket;
import net.povstalec.sgjourney.common.sgjourney.ITransmissionReceiver;

public class GDOItem
extends Item {
    public static final String IDC = "idc";
    public static final String FREQUENCY = "frequency";

    public GDOItem(Item.Properties properties) {
        super(properties);
    }

    public static void sendTransmission(Level level, Player player, ItemStack stack) {
        int roundedRadius = (int)Math.ceil(GDOItem.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = level.getChunk(player.getOnPos().east(16 * x).south(16 * z));
                Set positions = chunk.getBlockEntitiesPos();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        receiver.receiveTransmission(0, GDOItem.getFrequency(stack), GDOItem.getTransmissionMessage(stack));
                    }
                });
            }
        }
    }

    private static double distance2(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.getX() - pos.getX());
        int y = Math.abs(targetPos.getY() - pos.getY());
        int z = Math.abs(targetPos.getZ() - pos.getZ());
        return x * x + y * y + z * z;
    }

    private static void checkShieldingState(Level level, Player player) {
        int roundedRadius = (int)Math.ceil(GDOItem.transmissionRadius() / 16.0f);
        BlockPos playerPos = player.getOnPos().above();
        ArrayList stargates = new ArrayList();
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = level.getChunk(player.getOnPos().east(16 * x).south(16 * z));
                Set positions = chunk.getBlockEntitiesPos();
                positions.stream().forEach(pos -> {
                    AbstractStargateEntity stargate;
                    BlockEntity patt0$temp = level.getBlockEntity(pos);
                    if (patt0$temp instanceof AbstractStargateEntity && GDOItem.distance2(playerPos, (stargate = (AbstractStargateEntity)patt0$temp).getBlockPos()) <= (double)GDOItem.transmissionRadius2()) {
                        stargates.add(stargate);
                    }
                });
            }
        }
        if (stargates.size() == 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.gdo.error.no_nearby_stargate").withStyle(ChatFormatting.RED), true);
            return;
        }
        stargates.sort((stargateA, stargateB) -> Double.valueOf(GDOItem.distance2(playerPos, stargateA.getBlockPos())).compareTo(GDOItem.distance2(playerPos, stargateB.getBlockPos())));
        AbstractStargateEntity stargate = (AbstractStargateEntity)stargates.get(0);
        if (!stargate.isConnected()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.gdo.error.stargate_not_connected").withStyle(ChatFormatting.RED), true);
            return;
        }
        int shieldingProgress = Math.round(stargate.checkConnectionShieldingState());
        ChatFormatting formatting = shieldingProgress == 0 ? ChatFormatting.DARK_GREEN : (shieldingProgress < 10 ? ChatFormatting.GREEN : (shieldingProgress < 50 ? ChatFormatting.YELLOW : (shieldingProgress < 70 ? ChatFormatting.GOLD : (shieldingProgress < 90 ? ChatFormatting.RED : ChatFormatting.DARK_RED))));
        player.displayClientMessage((Component)Component.translatable((String)"message.sgjourney.gdo.shielded").append((Component)Component.literal((String)(": " + shieldingProgress + "%"))).withStyle(formatting), true);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide()) {
            return super.use(level, player, usedHand);
        }
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundGDOOpenScreenPacket(player.getUUID(), usedHand == InteractionHand.MAIN_HAND, GDOItem.getTransmissionMessage(stack), GDOItem.getFrequency(stack)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return super.use(level, player, usedHand);
        }
        GDOItem.checkShieldingState(level, player);
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int frequency = GDOItem.getFrequency(stack);
        String idc = GDOItem.getTransmissionMessage(stack);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.gdo.frequency").append((Component)Component.literal((String)(": " + frequency))).withStyle(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.gdo.idc").append((Component)Component.literal((String)(": " + idc))).withStyle(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.gdo.description.check").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.gdo.description.gui").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_gdo_transmission_distance.get()).intValue();
    }

    public static float transmissionRadius2() {
        return GDOItem.transmissionRadius() * GDOItem.transmissionRadius();
    }

    public static String getTransmissionMessage(ItemStack stack) {
        if (stack.getItem() instanceof GDOItem) {
            return (String)stack.getOrDefault(DataComponentInit.IDC, (Object)"");
        }
        return "";
    }

    public static int getFrequency(ItemStack stack) {
        if (stack.getItem() instanceof GDOItem) {
            return (Integer)stack.getOrDefault(DataComponentInit.FREQUENCY, (Object)0);
        }
        return 0;
    }

    public static void setFrequencyAndIDC(ItemStack stack, int frequency, String idc) {
        if (stack.getItem() instanceof GDOItem) {
            stack.set(DataComponentInit.FREQUENCY, (Object)frequency);
            stack.set(DataComponentInit.IDC, (Object)idc);
        }
    }
}

