/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.povstalec.sgjourney.common.capabilities.GoauldHost;
import net.povstalec.sgjourney.common.entities.Goauld;
import net.povstalec.sgjourney.common.init.EntityInit;

public class GoauldItem
extends Item {
    public GoauldItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos spawnPos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        Entity entity = EntityInit.GOAULD.get().spawn((ServerLevel)level, itemstack, context.getPlayer(), spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, spawnPos) && direction == Direction.UP);
        if (entity instanceof Goauld) {
            Goauld goauld = (Goauld)entity;
            goauld.loadFromItem(itemstack);
            itemstack.shrink(1);
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Mob mob;
        if (player.level().isClientSide()) {
            return super.interactLivingEntity(stack, player, target, hand);
        }
        GoauldHost cap = (GoauldHost)target.getCapability(GoauldHost.GOAULD_HOST_CAPABILITY);
        if (cap == null || !(target instanceof Mob) || !cap.takeOverHost(stack, mob = (Mob)target)) {
            return InteractionResult.FAIL;
        }
        target.hurt(player.damageSources().generic(), 1.0f);
        stack.shrink(1);
        return InteractionResult.CONSUME;
    }
}

