/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.tech.GoauldTech;

public class KaraKeshItem
extends Item
implements GoauldTech {
    private boolean terrorModeOn = false;
    private CompoundTag itemTag = new CompoundTag();
    private Random random = new Random();

    public KaraKeshItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide()) {
            return super.use(level, player, usedHand);
        }
        if (this.canUseGoauldTech((Boolean)CommonTechConfig.disable_kara_kesh_requirements.get(), (Entity)player) && player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(usedHand);
            if (((Boolean)stack.getOrDefault(DataComponentInit.TERROR_MODE, (Object)false)).booleanValue()) {
                stack.set(DataComponentInit.TERROR_MODE, (Object)true);
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.sgjourney.kara_kesh.terror").withStyle(ChatFormatting.RED), true);
            } else {
                stack.set(DataComponentInit.TERROR_MODE, (Object)false);
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.sgjourney.kara_kesh.knockback").withStyle(ChatFormatting.GOLD), true);
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.getCooldowns().isOnCooldown((Item)this) && !player.isShiftKeyDown()) {
            if (stack.get(DataComponentInit.TERROR_MODE) != null || !((Boolean)stack.get(DataComponentInit.TERROR_MODE)).booleanValue()) {
                target.knockback(2.0, player.getX() - target.getX(), player.getZ() - target.getZ());
                player.getCooldowns().addCooldown((Item)this, 50);
            } else {
                target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 1));
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 1));
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 255));
                player.getCooldowns().addCooldown((Item)this, 200);
            }
            target.playSound(SoundEvents.BLAZE_SHOOT, 0.5f, this.random.nextFloat() * 0.4f + 0.8f);
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos position, Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.get(DataComponentInit.TERROR_MODE) != null && ((Boolean)stack.get(DataComponentInit.TERROR_MODE)).booleanValue()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.kara_kesh.terror").withStyle(ChatFormatting.RED));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.kara_kesh.knockback").withStyle(ChatFormatting.GOLD));
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.kara_kesh.terror_knockback").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.kara_kesh.use").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

