/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.FluidItem;
import net.povstalec.sgjourney.common.items.VialItem;
import net.povstalec.sgjourney.common.misc.ComponentHelper;

public class PowerCellItem
extends FluidItem.Holder {
    public PowerCellItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isCorrectFluid(FluidStack fluidStack) {
        return fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    public ItemStack getHeldItem(ItemStack holderStack) {
        IItemHandler itemHandler = (IItemHandler)holderStack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler == null) {
            return ItemStack.EMPTY;
        }
        return itemHandler.getStackInSlot(0);
    }

    @Override
    public boolean isValidItem(ItemStack heldStack) {
        return heldStack.getItem() instanceof VialItem;
    }

    public long getBufferEnergy(ItemStack stack) {
        return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)0L);
    }

    public long getEnergyTransfer(ItemStack stack) {
        return (Long)CommonTechConfig.naquadah_power_cell_max_transfer.get();
    }

    public long getBufferCapacity(ItemStack stack) {
        return (Long)CommonTechConfig.naquadah_power_cell_buffer_capacity.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy_buffer").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(this.getBufferEnergy(stack), this.getBufferCapacity(stack))))).withStyle(ChatFormatting.DARK_RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)ComponentHelper.description("tooltip.sgjourney.naquadah_power_cell.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("tooltip.sgjourney.naquadah_power_cell.reload").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    public static ItemStack liquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.NAQUADAH_POWER_CELL.get());
        IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            itemHandler.insertItem(0, VialItem.liquidNaquadahSetup(), false);
        }
        return stack;
    }

    public static ItemStack heavyLiquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.NAQUADAH_POWER_CELL.get());
        IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            itemHandler.insertItem(0, VialItem.heavyLiquidNaquadahSetup(), false);
        }
        return stack;
    }

    public static class FluidItemHandler
    extends FluidItem.Holder.FluidItemHandler {
        public FluidItemHandler(ItemStack stack, DataComponentType<ItemContainerContents> component) {
            super(stack, component);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.is((Item)ItemInit.VIAL.get());
        }
    }

    public static class Energy
    extends SGJourneyEnergy.Item {
        public Energy(ItemStack stack) {
            super(stack, (Long)CommonTechConfig.naquadah_power_cell_buffer_capacity.get(), (Long)CommonTechConfig.naquadah_power_cell_max_transfer.get(), (Long)CommonTechConfig.naquadah_power_cell_max_transfer.get());
        }

        private long convertFluidToEnergy(long maxExtract, long energyFromFluid, boolean simulate) {
            long drained = maxExtract / energyFromFluid;
            int toDrain = (int)Math.min((long)((PowerCellItem)this.stack.getItem()).getFluidAmount(this.stack), drained);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler instanceof FluidItem.Holder.FluidItemHandler) {
                FluidItem.Holder.FluidItemHandler fluidItemHandler = (FluidItem.Holder.FluidItemHandler)fluidHandler;
                fluidItemHandler.deplete(toDrain, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                return (long)toDrain * energyFromFluid;
            }
            return 0L;
        }

        public long convertLiquidNaquadahToEnergy(long maxExtract, boolean simulate) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)this.stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler instanceof FluidItem.Holder.FluidItemHandler) {
                FluidItem.Holder.FluidItemHandler fluidItemHandler = (FluidItem.Holder.FluidItemHandler)fluidHandler;
                FluidStack fluidStack = fluidItemHandler.getFluidInTank(0);
                if (fluidStack.getAmount() <= 0) {
                    return 0L;
                }
                if (fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get()) {
                    return this.convertFluidToEnergy(maxExtract, (Long)CommonTechConfig.energy_from_liquid_naquadah.get(), simulate);
                }
                if (fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()) {
                    return this.convertFluidToEnergy(maxExtract, (Long)CommonTechConfig.energy_from_heavy_liquid_naquadah.get(), simulate);
                }
            }
            return 0L;
        }

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            return 0L;
        }

        @Override
        public long extractLongEnergy(long maxExtract, boolean simulate) {
            long currentEnergy = this.getTrueEnergyStored();
            if (currentEnergy >= maxExtract) {
                return super.extractLongEnergy(maxExtract, simulate);
            }
            long convertedEnergy = this.convertLiquidNaquadahToEnergy(maxExtract, simulate);
            if (convertedEnergy <= 0L) {
                return super.extractLongEnergy(maxExtract, simulate);
            }
            long extractedEnergy = Math.min(maxExtract, currentEnergy += convertedEnergy);
            long energyLeft = currentEnergy - extractedEnergy;
            if (!simulate) {
                this.setEnergy(Math.min(this.getTrueMaxEnergyStored(), energyLeft));
            }
            return extractedEnergy;
        }

        @Override
        public long maxReceive() {
            Item item = this.stack.getItem();
            if (item instanceof PowerCellItem) {
                PowerCellItem powerCell = (PowerCellItem)item;
                return powerCell.getEnergyTransfer(this.stack);
            }
            return 0L;
        }

        @Override
        public long maxExtract() {
            Item item = this.stack.getItem();
            if (item instanceof PowerCellItem) {
                PowerCellItem powerCell = (PowerCellItem)item;
                return powerCell.getEnergyTransfer(this.stack);
            }
            return 0L;
        }

        @Override
        public long loadEnergy(ItemStack stack) {
            return (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)0L);
        }

        @Override
        public long getTrueMaxEnergyStored() {
            Item item = this.stack.getItem();
            if (item instanceof PowerCellItem) {
                PowerCellItem powerCell = (PowerCellItem)item;
                return powerCell.getBufferCapacity(this.stack);
            }
            return 0L;
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            this.stack.set(DataComponentInit.ENERGY, (Object)this.energy);
        }
    }
}

