/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;

public abstract class StargateIrisItem
extends Item {
    public static final ResourceLocation COPPER_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/copper_iris.png");
    public static final ResourceLocation IRON_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/iron_iris.png");
    public static final ResourceLocation GOLD_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/golden_iris.png");
    public static final ResourceLocation DIAMOND_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/diamond_iris.png");
    public static final ResourceLocation NETHERITE_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/netherite_iris.png");
    public static final ResourceLocation NAQUADAH_ALLOY_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/naquadah_alloy_iris.png");
    public static final ResourceLocation TRINIUM_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/trinium_iris.png");
    public static final ResourceLocation BRONZE_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/bronze_iris.png");
    public static final ResourceLocation STEEL_IRIS = StargateJourney.sgjourneyLocation("textures/entity/stargate/iris/steel_iris.png");
    private ResourceLocation irisTexture;

    public StargateIrisItem(Item.Properties properties, ResourceLocation irisTexture) {
        super(properties);
        this.irisTexture = irisTexture;
    }

    public ResourceLocation getIrisTexture() {
        return this.irisTexture;
    }

    public abstract int getMaxDurability();

    public static boolean hasCustomTexture(ItemStack stack) {
        return stack.has(DataComponentInit.IRIS_TEXTURE);
    }

    @Nullable
    public static ResourceLocation getIrisTexture(ItemStack stack) {
        ResourceLocation location = (ResourceLocation)stack.get(DataComponentInit.IRIS_TEXTURE);
        if (location != null) {
            return location;
        }
        Item item = stack.getItem();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem irisItem = (StargateIrisItem)item;
            return irisItem.getIrisTexture();
        }
        return null;
    }

    public static int getDurability(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem iris = (StargateIrisItem)item;
            return (Integer)stack.getOrDefault(DataComponentInit.IRIS_DURABILITY, (Object)iris.getMaxDurability());
        }
        return 0;
    }

    public static boolean decreaseDurability(ItemStack stack) {
        int durability = StargateIrisItem.getDurability(stack);
        if (durability > 0) {
            stack.set(DataComponentInit.IRIS_DURABILITY, (Object)(--durability));
            return durability >= 1;
        }
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return StargateIrisItem.getDurability(stack) < this.getMaxDurability();
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)StargateIrisItem.getDurability(stack) / (float)this.getMaxDurability());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)StargateIrisItem.getDurability(stack) / (float)this.getMaxDurability());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (tooltipFlag.isAdvanced()) {
            int durability = StargateIrisItem.getDurability(stack);
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.iris.durability").append((Component)Component.literal((String)(": " + durability + " / " + this.getMaxDurability()))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Steel
    extends StargateIrisItem {
        public Steel(Item.Properties properties) {
            super(properties, STEEL_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.steel_iris_durability.get();
        }
    }

    public static class Bronze
    extends StargateIrisItem {
        public Bronze(Item.Properties properties) {
            super(properties, BRONZE_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.bronze_iris_durability.get();
        }
    }

    public static class Trinium
    extends StargateIrisItem {
        public Trinium(Item.Properties properties) {
            super(properties, TRINIUM_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.trinium_iris_durability.get();
        }
    }

    public static class NaquadahAlloy
    extends StargateIrisItem {
        public NaquadahAlloy(Item.Properties properties) {
            super(properties, NAQUADAH_ALLOY_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.naquadah_alloy_iris_durability.get();
        }
    }

    public static class Netherite
    extends StargateIrisItem {
        public Netherite(Item.Properties properties) {
            super(properties, NETHERITE_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.netherite_iris_durability.get();
        }
    }

    public static class Diamond
    extends StargateIrisItem {
        public Diamond(Item.Properties properties) {
            super(properties, DIAMOND_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.diamond_iris_durability.get();
        }
    }

    public static class Gold
    extends StargateIrisItem {
        public Gold(Item.Properties properties) {
            super(properties, GOLD_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.gold_iris_durability.get();
        }
    }

    public static class Iron
    extends StargateIrisItem {
        public Iron(Item.Properties properties) {
            super(properties, IRON_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.iron_iris_durability.get();
        }
    }

    public static class Copper
    extends StargateIrisItem {
        public Copper(Item.Properties properties) {
            super(properties, COPPER_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.copper_iris_durability.get();
        }
    }
}

