/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.ItemInit;

public class StargateUpgradeItem
extends Item {
    public StargateUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public Optional<AbstractStargateBaseBlock> getStargateBaseBlock(ItemStack stack) {
        Block block;
        ResourceLocation location = (ResourceLocation)stack.get(DataComponentInit.STARGATE_UPGRADE);
        if (location != null && (block = (Block)BuiltInRegistries.BLOCK.get(location)) instanceof AbstractStargateBaseBlock) {
            AbstractStargateBaseBlock stargateBlock = (AbstractStargateBaseBlock)block;
            return Optional.of(stargateBlock);
        }
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ResourceLocation location = (ResourceLocation)stack.get(DataComponentInit.STARGATE_UPGRADE);
        if (location != null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.stargate_type").append((Component)Component.literal((String)(": " + location.toString()))).withStyle(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.stargate_upgrade.description").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static <StargateBlock extends AbstractStargateBlock> ItemStack stargateType(StargateBlock stargate) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.STARGATE_UPGRADE_CRYSTAL.get());
        stack.set(DataComponentInit.STARGATE_UPGRADE, (Object)BuiltInRegistries.BLOCK.getKey(stargate));
        return stack;
    }
}

