/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public class StargateVariantItem
extends Item {
    public StargateVariantItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(DataComponentInit.STARGATE_VARIANT);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has(DataComponentInit.STARGATE_VARIANT)) {
            RegistryAccess.Frozen registries;
            Registry stargateVariantRegistry;
            ResourceLocation variant = StargateVariantItem.getStargateVariant(stack);
            Minecraft minecraft = Minecraft.getInstance();
            ClientPacketListener clientPacketListener = minecraft.getConnection();
            if (clientPacketListener != null && (stargateVariantRegistry = (registries = clientPacketListener.registryAccess()).registryOrThrow(StargateVariant.REGISTRY_KEY)).containsKey(variant)) {
                Block block;
                ResourceLocation baseStargate = ((StargateVariant)stargateVariantRegistry.get(variant)).getBaseStargate();
                if (BuiltInRegistries.BLOCK.containsKey(baseStargate) && (block = (Block)BuiltInRegistries.BLOCK.get(((StargateVariant)stargateVariantRegistry.get(variant)).getBaseStargate())) != null) {
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.requires").append((Component)Component.literal((String)": ").append((Component)block.getName())).withStyle(ChatFormatting.LIGHT_PURPLE));
                }
                if (tooltipFlag.isAdvanced()) {
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.requires").append((Component)Component.literal((String)(": " + baseStargate.toString()))).withStyle(ChatFormatting.BLUE));
                }
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.variant").append((Component)Component.literal((String)(": " + String.valueOf(variant)))).withStyle(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.stargate_variant.description").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Nullable
    public static ResourceLocation getStargateVariant(ItemStack stack) {
        return (ResourceLocation)stack.get(DataComponentInit.STARGATE_VARIANT);
    }

    public static <StargateBlock extends AbstractStargateBlock> ItemStack stargateVariant(ResourceLocation variant) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.STARGATE_VARIANT_CRYSTAL.get());
        stack.set(DataComponentInit.STARGATE_VARIANT, (Object)variant);
        return stack;
    }
}

