/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.FluidItem;
import org.jetbrains.annotations.NotNull;

public class VialItem
extends FluidItem {
    public VialItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isCorrectFluid(FluidStack fluidStack) {
        return fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
    }

    @Override
    public int getFluidCapacity(ItemStack stack) {
        return (Integer)CommonTechConfig.vial_capacity.get();
    }

    public static ItemStack liquidNaquadahSetup(int amount) {
        return FluidItem.fluidSetup((Item)ItemInit.VIAL.get(), (Fluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get(), amount);
    }

    public static ItemStack liquidNaquadahSetup() {
        return VialItem.liquidNaquadahSetup((Integer)CommonTechConfig.vial_capacity.get());
    }

    public static ItemStack heavyLiquidNaquadahSetup(int amount) {
        return FluidItem.fluidSetup((Item)ItemInit.VIAL.get(), (Fluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get(), amount);
    }

    public static ItemStack heavyLiquidNaquadahSetup() {
        return VialItem.heavyLiquidNaquadahSetup((Integer)CommonTechConfig.vial_capacity.get());
    }

    public static class FluidHandler
    extends FluidHandlerItemStack {
        public FluidHandler(Supplier<DataComponentType<SimpleFluidContent>> componentType, ItemStack container) {
            super(componentType, container, ((Integer)CommonTechConfig.vial_capacity.get()).intValue());
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get() || stack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
        }
    }
}

