/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.armor;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.tech.AncientTech;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersonalShieldItem
extends ArmorItem
implements AncientTech {
    public PersonalShieldItem(Holder<ArmorMaterial> material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public static int getMaxCapacity() {
        return (Integer)CommonTechConfig.personal_shield_capacity.get();
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)PersonalShieldItem.getFluidAmount(stack) / (float)PersonalShieldItem.getMaxCapacity());
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, (float)PersonalShieldItem.getFluidAmount(stack) / (float)PersonalShieldItem.getMaxCapacity());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return 0;
    }

    public static int getFluidAmount(ItemStack stack) {
        FluidStack fluidStack = PersonalShieldItem.getFluidStack(stack);
        return fluidStack.getAmount();
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            return cap.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public static void drainNaquadah(ItemStack stack, int amount) {
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            cap.drain(amount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        FluidStack fluidStack = PersonalShieldItem.getFluidStack(stack);
        if (!PersonalShieldItem.getFluidStack(stack).equals(FluidStack.EMPTY)) {
            MutableComponent liquidNaquadah = Component.translatable((String)fluidStack.getFluidType().getDescriptionId(fluidStack)).withStyle(ChatFormatting.GREEN);
            liquidNaquadah.append((Component)Component.literal((String)(" " + fluidStack.getAmount() + "mB")).withStyle(ChatFormatting.GREEN));
            tooltipComponents.add((Component)liquidNaquadah);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static ItemStack personalShieldSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.PERSONAL_SHIELD_EMITTER.get());
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            cap.fill(new FluidStack(((FlowingFluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()).getSource(), PersonalShieldItem.getMaxCapacity()), IFluidHandler.FluidAction.EXECUTE);
        }
        return stack;
    }

    public static class FluidHandler
    extends FluidHandlerItemStack {
        public FluidHandler(Supplier<DataComponentType<SimpleFluidContent>> componentType, ItemStack container) {
            super(componentType, container, PersonalShieldItem.getMaxCapacity());
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get();
        }
    }
}

