/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.energy_cores;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.energy_cores.IEnergyCore;

public class FusionCoreItem
extends Item
implements IEnergyCore {
    public FusionCoreItem(Item.Properties properties) {
        super(properties);
    }

    private static boolean showEnergy() {
        return !StargateJourneyConfig.disable_energy_use.get() && (Boolean)CommonTechConfig.fusion_core_infinite_energy.get() == false;
    }

    public boolean isBarVisible(ItemStack stack) {
        return FusionCoreItem.showEnergy();
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)FusionCoreItem.getFuel(stack) / (float)FusionCoreItem.getMaxFuel());
    }

    public int getBarColor(ItemStack stack) {
        return 61183;
    }

    public static int getFuel(ItemStack energyCore) {
        return (Integer)energyCore.getOrDefault(DataComponentInit.FUSION_FUEL, (Object)FusionCoreItem.getMaxFuel());
    }

    public static int getMaxFuel() {
        return (Integer)CommonTechConfig.fusion_core_fuel_capacity.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (FusionCoreItem.showEnergy()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.fusion_core.fuel").append((Component)Component.literal((String)(": " + FusionCoreItem.getFuel(stack) + " / " + FusionCoreItem.getMaxFuel()))).withStyle(ChatFormatting.AQUA));
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.fusion_core.description").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public long maxGeneratedEnergy(ItemStack energyCore, ItemStack input) {
        return (Long)CommonTechConfig.fusion_core_energy_from_fuel.get();
    }

    @Override
    public long generateEnergy(ItemStack energyCore, ItemStack input) {
        if (((Boolean)CommonTechConfig.fusion_core_infinite_energy.get()).booleanValue()) {
            return this.maxGeneratedEnergy(energyCore, input);
        }
        int fuel = FusionCoreItem.getFuel(energyCore);
        if (fuel > 0) {
            energyCore.set(DataComponentInit.FUSION_FUEL, (Object)(fuel - 1));
            return this.maxGeneratedEnergy(energyCore, input);
        }
        return 0L;
    }

    public static ItemStack randomFusionCore(int minCapacity, int maxCapacity) {
        ItemStack fusionCore = new ItemStack((ItemLike)ItemInit.FUSION_CORE.get());
        Random random = new Random();
        fusionCore.set(DataComponentInit.FUSION_FUEL, (Object)random.nextInt(minCapacity, maxCapacity + 1));
        return fusionCore;
    }
}

