/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.packets.ServerboundDHDUpdatePacket;

public abstract class AbstractDHDMenu
extends AbstractContainerMenu {
    protected final AbstractDHDEntity blockEntity;
    protected final Level level;
    public String symbolsType = "sgjourney:milky_way";

    public AbstractDHDMenu(MenuType<?> menu, int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(menu, containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public AbstractDHDMenu(MenuType<?> menu, int containerId, Inventory inv, BlockEntity entity) {
        super(menu, containerId);
        AbstractDHDMenu.checkContainerSize((Container)inv, (int)9);
        this.blockEntity = (AbstractDHDEntity)entity;
        this.level = inv.player.level();
    }

    public void engageChevron(int symbol) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundDHDUpdatePacket(this.blockEntity.getBlockPos(), symbol), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isSymbolEngaged(int symbol) {
        if (this.blockEntity != null) {
            return this.blockEntity.isSymbolEngaged(symbol);
        }
        return false;
    }

    public boolean isCenterButtonEngaged() {
        if (this.blockEntity != null) {
            return this.blockEntity.isCenterButtonEngaged();
        }
        return false;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return null;
    }
}

