/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;

public class CrystallizerMenu
extends InventoryMenu {
    protected final AbstractCrystallizerEntity blockEntity;
    protected final Level level;
    protected FluidStack fluidStack;

    public CrystallizerMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public CrystallizerMenu(int containerId, Inventory inventory, BlockEntity blockEntity) {
        super((MenuType)MenuInit.CRYSTALLIZER.get(), containerId);
        IItemHandler cap4;
        IItemHandler cap3;
        IItemHandler cap2;
        IItemHandler cap1;
        CrystallizerMenu.checkContainerSize((Container)inventory, (int)5);
        this.blockEntity = (AbstractCrystallizerEntity)blockEntity;
        this.level = inventory.player.level();
        this.fluidStack = this.blockEntity.getFluid();
        this.addPlayerInventory(inventory, 8, 84);
        this.addPlayerHotbar(inventory, 8, 142);
        IItemHandler cap0 = (IItemHandler)this.blockEntity.getItemHandler(0).get();
        if (cap0 != null) {
            this.addSlot((Slot)new SlotItemHandler(cap0, 0, 80, 20));
        }
        if ((cap1 = (IItemHandler)this.blockEntity.getItemHandler(1).get()) != null) {
            this.addSlot((Slot)new SlotItemHandler(cap1, 0, 67, 50));
        }
        if ((cap2 = (IItemHandler)this.blockEntity.getItemHandler(2).get()) != null) {
            this.addSlot((Slot)new SlotItemHandler(cap2, 0, 93, 50));
        }
        if ((cap3 = (IItemHandler)this.blockEntity.getItemHandler(3).get()) != null) {
            this.addSlot((Slot)new SlotItemHandler(cap3, 0, 130, 36));
        }
        if ((cap4 = (IItemHandler)this.blockEntity.getItemHandler(4).get()) != null) {
            this.addSlot((Slot)new SlotItemHandler(cap4, 0, 34, 20));
        }
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluid() {
        return this.blockEntity.getFluid();
    }

    public Fluid getDesiredFluid() {
        return this.blockEntity.getDesiredFluid();
    }

    public int getProgress() {
        return this.blockEntity.progress;
    }

    public boolean stillValid(Player player) {
        return CrystallizerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.CRYSTALLIZER.get())) || CrystallizerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.ADVANCED_CRYSTALLIZER.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 5;
    }

    private boolean hasRequiredLiquid(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            return fluidHandler.getFluidInTank(0).is(this.blockEntity.getDesiredFluid());
        }
        return false;
    }

    private static boolean countEquals(ItemStack first, ItemStack second) {
        return first.getCount() == second.getCount();
    }

    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        boolean stopQuickMove = false;
        if (index < 36) {
            stopQuickMove = true;
            if (this.hasRequiredLiquid(sourceStack)) {
                this.moveItemStackTo(sourceStack, 40, 41, false);
            }
            if (CrystallizerMenu.countEquals(sourceStack, copyOfSourceStack) && !this.moveItemStackTo(sourceStack, 36, 36 + this.TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 36 + this.TE_INVENTORY_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        if (stopQuickMove) {
            return ItemStack.EMPTY;
        }
        return copyOfSourceStack;
    }
}

