/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.transporter.RingPanelEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.menu.InventoryMenu;
import net.povstalec.sgjourney.common.packets.ServerboundRingPanelUpdatePacket;

public class RingPanelMenu
extends InventoryMenu {
    private final RingPanelEntity blockEntity;
    private final Level level;

    public RingPanelMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public RingPanelMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super((MenuType)MenuInit.RING_PANEL.get(), containerId);
        RingPanelMenu.checkContainerSize((Container)inventory, (int)6);
        this.blockEntity = (RingPanelEntity)entity;
        this.level = inventory.player.level();
        this.addPlayerInventory(inventory, 8, 140);
        this.addPlayerHotbar(inventory, 8, 198);
        IItemHandler cap = this.blockEntity.getItemHandler();
        if (cap != null) {
            this.addSlot((Slot)new SlotItemHandler(cap, 0, 5, 36));
            this.addSlot((Slot)new SlotItemHandler(cap, 1, 23, 36));
            this.addSlot((Slot)new SlotItemHandler(cap, 2, 5, 54));
            this.addSlot((Slot)new SlotItemHandler(cap, 3, 23, 54));
            this.addSlot((Slot)new SlotItemHandler(cap, 4, 5, 72));
            this.addSlot((Slot)new SlotItemHandler(cap, 5, 23, 72));
        }
    }

    public Component getRingsPos(int i) {
        if (i < this.blockEntity.ringsPos.size()) {
            BlockPos coords = this.blockEntity.ringsPos.get(i);
            Component name = this.blockEntity.ringsName.get(i);
            if (name.getString().length() == 0) {
                return Component.literal((String)("[" + coords.getX() + " " + coords.getY() + " " + coords.getZ() + "]")).withStyle(ChatFormatting.DARK_GREEN);
            }
            return Component.empty().append(name).withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)(" [" + coords.getX() + " " + coords.getY() + " " + coords.getZ() + "] ")).withStyle(ChatFormatting.DARK_GREEN));
        }
        return Component.literal((String)"-");
    }

    public void activateRings(int number) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundRingPanelUpdatePacket(this.blockEntity.getBlockPos(), number), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public int[] getTargetCoords(int chosenNumber) {
        return this.blockEntity.getTargetCoords(chosenNumber);
    }

    public boolean stillValid(Player player) {
        return RingPanelMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)BlockInit.RING_PANEL.get()));
    }

    @Override
    protected int blockEntitySlotCount() {
        return 6;
    }
}

