/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.misc.Conversion;

public class ComponentHelper {
    public static MutableComponent energy(String name, long energy, long maxEnergy) {
        return Component.translatable((String)name).append(": " + SGJourneyEnergy.energyToString(energy, maxEnergy)).withStyle(ChatFormatting.DARK_RED);
    }

    public static MutableComponent energy(long energy, long maxEnergy) {
        return ComponentHelper.energy("tooltip.sgjourney.energy", energy, maxEnergy);
    }

    public static MutableComponent energy(String name, long energy) {
        return Component.translatable((String)name).append(": " + SGJourneyEnergy.energyToString(energy)).withStyle(ChatFormatting.DARK_RED);
    }

    public static MutableComponent energy(long energy) {
        return ComponentHelper.energy("tooltip.sgjourney.energy", energy);
    }

    public static MutableComponent tickTimer(String name, int ticks, int maxTicks, ChatFormatting formatting) {
        if (maxTicks <= 0) {
            return Component.translatable((String)name).append(": " + Conversion.ticksToString(ticks)).withStyle(formatting);
        }
        return Component.translatable((String)name).append(": " + Conversion.ticksToString(ticks) + "/" + Conversion.ticksToString(maxTicks)).withStyle(formatting);
    }

    public static MutableComponent tickTimer(int ticks, int maxTicks, ChatFormatting formatting) {
        return Component.literal((String)(Conversion.ticksToString(ticks) + "/" + Conversion.ticksToString(maxTicks))).withStyle(formatting);
    }

    public static MutableComponent description(MutableComponent component) {
        return component.withStyle(ChatFormatting.DARK_GRAY);
    }

    public static MutableComponent description(String name) {
        return ComponentHelper.description(Component.translatable((String)name));
    }

    public static MutableComponent usage(MutableComponent component) {
        return component.withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC);
    }

    public static MutableComponent usage(String name) {
        return ComponentHelper.usage(Component.translatable((String)name));
    }
}

