/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundAccess;

public abstract class ClientBoundSoundPackets {

    public record RotationStop(BlockPos blockPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RotationStop> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_rotation_stop_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, RotationStop> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RotationStop::blockPos, RotationStop::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(RotationStop packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playRotationStopSound(packet.blockPos));
        }
    }

    public record RotationStartup(BlockPos blockPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RotationStartup> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_rotation_startup_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, RotationStartup> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RotationStartup::blockPos, RotationStartup::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(RotationStartup packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playRotationStartupSound(packet.blockPos));
        }
    }

    public record UniverseStart(BlockPos blockPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<UniverseStart> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_universe_start_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, UniverseStart> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UniverseStart::blockPos, UniverseStart::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(UniverseStart packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playUniverseDialStartSound(packet.blockPos));
        }
    }

    public record StargateRotation(BlockPos blockPos, boolean stop) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<StargateRotation> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_stargate_rotation"));
        public static final StreamCodec<RegistryFriendlyByteBuf, StargateRotation> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, StargateRotation::blockPos, (StreamCodec)ByteBufCodecs.BOOL, StargateRotation::stop, StargateRotation::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(StargateRotation packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playRotationSound(packet.blockPos, packet.stop));
        }
    }

    public record Fail(BlockPos blockPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Fail> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_stargate_fail_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Fail> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, Fail::blockPos, Fail::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(Fail packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playFailSound(packet.blockPos));
        }
    }

    public record Chevron(BlockPos blockPos, short chevron, boolean incoming, boolean open, boolean encode) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Chevron> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_stargate_chevron_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Chevron> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, Chevron::blockPos, (StreamCodec)ByteBufCodecs.SHORT, Chevron::chevron, (StreamCodec)ByteBufCodecs.BOOL, Chevron::incoming, (StreamCodec)ByteBufCodecs.BOOL, Chevron::open, (StreamCodec)ByteBufCodecs.BOOL, Chevron::encode, Chevron::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(Chevron packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playChevronSound(packet.blockPos, packet.chevron, packet.incoming, packet.open, packet.encode));
        }
    }

    public record IrisThud(BlockPos blockPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<IrisThud> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_iris_thud_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, IrisThud> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, IrisThud::blockPos, IrisThud::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(IrisThud packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playIrisThudSound(packet.blockPos));
        }
    }

    public record CloseWormhole(BlockPos blockPos, boolean incoming) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<CloseWormhole> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_close_wormhole_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, CloseWormhole> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CloseWormhole::blockPos, (StreamCodec)ByteBufCodecs.BOOL, CloseWormhole::incoming, CloseWormhole::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(CloseWormhole packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playWormholeCloseSound(packet.blockPos, packet.incoming));
        }
    }

    public record IdleWormhole(BlockPos blockPos, boolean incoming) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<IdleWormhole> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_idle_wormhole_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, IdleWormhole> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, IdleWormhole::blockPos, (StreamCodec)ByteBufCodecs.BOOL, IdleWormhole::incoming, IdleWormhole::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(IdleWormhole packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playWormholeIdleSound(packet.blockPos, packet.incoming));
        }
    }

    public record OpenWormhole(BlockPos blockPos, boolean incoming) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenWormhole> TYPE = new CustomPacketPayload.Type(StargateJourney.sgjourneyLocation("s2c_open_wormhole_sound"));
        public static final StreamCodec<RegistryFriendlyByteBuf, OpenWormhole> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenWormhole::blockPos, (StreamCodec)ByteBufCodecs.BOOL, OpenWormhole::incoming, OpenWormhole::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(OpenWormhole packet, IPayloadContext ctx) {
            ctx.enqueueWork(() -> SoundAccess.playWormholeOpenSound(packet.blockPos, packet.incoming));
        }
    }
}

