/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;

public class StargateBlockCover
implements INBTSerializable<CompoundTag> {
    private ArrayList<StargatePart> parts;
    public boolean canSinkGate = false;
    public HashMap<StargatePart, BlockState> blockStates = new HashMap();

    public StargateBlockCover(ArrayList<StargatePart> parts) {
        this.parts = parts;
    }

    public boolean setBlockAt(StargatePart part, BlockState state) {
        if (this.blockStates.containsKey((Object)part)) {
            return false;
        }
        this.blockStates.put(part, state);
        return true;
    }

    public Optional<BlockState> getBlockAt(StargatePart part) {
        if (this.blockStates.get((Object)part) != null && this.blockStates.get((Object)part).getBlock() instanceof AbstractStargateBlock) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.blockStates.get((Object)part));
    }

    public Optional<BlockState> removeBlockAt(StargatePart part) {
        BlockState oldState = this.blockStates.get((Object)part);
        this.blockStates.remove((Object)part);
        return Optional.ofNullable(oldState);
    }

    public boolean mineBlockAt(Level level, Player player, StargatePart part, BlockPos pos) {
        Optional<BlockState> removed = this.removeBlockAt(part);
        if (removed.isPresent()) {
            if (!level.isClientSide()) {
                BlockState state = removed.get();
                if (!player.isCreative() && player.hasCorrectToolForDrops(removed.get())) {
                    Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                }
                level.levelEvent((Player)null, 2001, pos, Block.getId((BlockState)state));
            }
            return true;
        }
        return false;
    }

    public ItemStack getStackAt(HitResult target, LevelReader level, Player player, StargatePart part, BlockPos pos) {
        Optional<BlockState> removed = this.getBlockAt(part);
        if (removed.isPresent()) {
            BlockState state = removed.get();
            return state.getCloneItemStack(target, level, pos, player);
        }
        return ItemStack.EMPTY;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<StargatePart, BlockState> entry : this.blockStates.entrySet()) {
            DataResult blockStateTag = BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getValue());
            Optional result = blockStateTag.result();
            if (!result.isPresent()) continue;
            tag.put(entry.getKey().getSerializedName(), (Tag)result.get());
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag tag) {
        for (StargatePart part : this.parts) {
            DataResult stateResult;
            Optional result;
            if (!tag.contains(part.getSerializedName()) || !(result = (stateResult = BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(part.getSerializedName()))).result()).isPresent()) continue;
            this.blockStates.put(part, (BlockState)result.get());
        }
    }
}

