/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;

public class SymbolSet {
    public static final ResourceLocation ERROR_LOCATION = StargateJourney.sgjourneyLocation("textures/symbols/error.png");
    public static final ResourceLocation SYMBOL_SET_LOCATION = StargateJourney.sgjourneyLocation("symbol_set");
    public static final ResourceKey<Registry<SymbolSet>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)SYMBOL_SET_LOCATION);
    public static final Codec<ResourceKey<SymbolSet>> RESOURCE_KEY_CODEC = ResourceKey.codec(REGISTRY_KEY);
    public static final Codec<SymbolSet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(SymbolSet::getName), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SymbolSet::getTexture), (App)Codec.INT.optionalFieldOf("size", (Object)38).forGetter(SymbolSet::getSize)).apply((Applicative)instance, SymbolSet::new));
    private final String name;
    private final ResourceLocation texture;
    private final int size;

    public SymbolSet(String name, ResourceLocation texture, int size) {
        this.name = name;
        this.texture = texture;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getSize() {
        return this.size;
    }

    public ResourceLocation getSymbolTexture() {
        ResourceLocation texture = StargateJourney.location(this.texture.getNamespace(), "textures/symbols/" + this.texture.getPath());
        return texture;
    }

    public boolean shouldRenderSymbol(int symbol) {
        return symbol >= 0 && symbol < this.size;
    }

    public static SymbolSet getClientSymbolSet(ResourceKey<SymbolSet> symbols) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
        Registry registry = registries.registryOrThrow(REGISTRY_KEY);
        return (SymbolSet)registry.get(symbols);
    }

    public static SymbolSet getSymbolSet(Level level, ResourceKey<SymbolSet> symbols) {
        RegistryAccess.Frozen registries = level.getServer().registryAccess();
        Registry registry = registries.registryOrThrow(REGISTRY_KEY);
        return (SymbolSet)registry.get(symbols);
    }

    public static SymbolSet getSymbolSet(Level level, String name) {
        String[] split = name.split(":");
        RegistryAccess.Frozen registries = level.getServer().registryAccess();
        Registry registry = registries.registryOrThrow(REGISTRY_KEY);
        return (SymbolSet)registry.get(StargateJourney.location(split[0], split[1]));
    }
}

