/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.factions;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.SpawnerStargate;

public class GoauldFaction {
    public static final int UPDATE_INTERVAL = 400;
    public static final int ATTACKER_MIN_COUNT = 3;
    public static final int ATTACKER_MAX_COUNT = 7;
    public static final int ATTACKER_MIN_INTERVAL = 20;
    public static final int ATTACKER_MAX_INTERVAL = 60;
    private static final Address.Immutable TERRA = new Address.Immutable(27, 25, 4, 35, 10, 28);
    private static final Address.Immutable ABYDOS = new Address.Immutable(26, 6, 14, 31, 11, 29);
    private static final Address.Immutable RIMA = new Address.Immutable(33, 20, 10, 22, 3, 17);
    private static final Address.Immutable UNITAS = new Address.Immutable(2, 27, 8, 34, 24, 15);
    protected List<Address.Immutable> addresses = new ArrayList<Address.Immutable>();
    protected final SpawnerStargate stargate;
    protected final Random random;
    @Nullable
    protected Address.Immutable incursionTarget;
    protected int incursionTime = 0;

    public GoauldFaction() {
        this.addresses.add(TERRA);
        this.stargate = new SpawnerStargate(Address.Immutable.randomAddress(8, 36, 0L), 3, 7, 20, 60);
        this.random = new Random(0L);
    }

    public void prepareNextIncursions(int intervalTicks) {
        if (this.addresses.isEmpty()) {
            return;
        }
        this.incursionTime = this.random.nextInt(intervalTicks, 400);
        this.incursionTarget = this.addresses.get(this.random.nextInt(this.addresses.size()));
        System.out.println("Next incursion at: " + this.incursionTime + " " + String.valueOf(this.incursionTarget));
    }

    public boolean launchIncursion(MinecraftServer server) {
        if (this.stargate.isConnected(server)) {
            return false;
        }
        if (this.incursionTarget == null) {
            return false;
        }
        this.stargate.encodeAddress(this.incursionTarget);
        StargateInfo.Feedback feedback = this.stargate.dial(server);
        System.out.println("Dial attempt: " + feedback.getMessage());
        return !feedback.isError();
    }

    public void tickFaction(MinecraftServer server, int ticks) {
        int intervalTicks = ticks % 400;
        if (intervalTicks == 0) {
            this.prepareNextIncursions(intervalTicks);
        } else if (intervalTicks == this.incursionTime) {
            if (!this.launchIncursion(server)) {
                this.prepareNextIncursions(intervalTicks);
            } else {
                this.incursionTarget = null;
            }
        }
    }
}

